/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.shaded.org.objectweb.asm.AnnotationVisitor;
import org.apache.flink.shaded.org.objectweb.asm.ClassVisitor;
import org.apache.flink.shaded.org.objectweb.asm.FieldVisitor;
import org.apache.flink.shaded.org.objectweb.asm.Label;
import org.apache.flink.shaded.org.objectweb.asm.MethodVisitor;
import org.apache.flink.shaded.org.objectweb.asm.Type;
import org.apache.flink.shaded.org.objectweb.asm.TypePath;
import org.apache.flink.shaded.org.objectweb.asm.signature.SignatureReader;
import org.apache.flink.shaded.org.objectweb.asm.signature.SignatureVisitor;

public class DependencyVisitor
extends ClassVisitor {
    private Set<String> packages = new HashSet<String>();
    private Set<String> nameSpace = new HashSet<String>();

    public Set<String> getPackages() {
        return this.packages;
    }

    public DependencyVisitor(int api) {
        super(api);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (signature == null) {
            this.addInternalName(superName);
            this.addInternalNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return new AnnotationVisitorImpl(327680);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return new FieldVisitorImpl(327680);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addInternalNames(exceptions);
        return new MethodVisitorImpl(327680);
    }

    public void addNameSpace(Set<String> names) {
        for (String name : names) {
            this.nameSpace.add(name.replace('.', '/'));
        }
    }

    private boolean checkUserDefine(String name) {
        String[] ns = new String[]{};
        for (String s : ns = this.nameSpace.toArray(ns)) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void addName(String name) {
        if (this.checkUserDefine(name)) {
            this.packages.add(name);
        }
    }

    private void addInternalName(String name) {
        this.addType(Type.getObjectType(name));
    }

    private void addInternalNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addInternalName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType(desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType(desc));
        Type[] types = Type.getArgumentTypes(desc);
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getInternalName());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept(new SignatureVisitorImpl(327680));
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType(new SignatureVisitorImpl(327680));
        }
    }

    public class SignatureVisitorImpl
    extends SignatureVisitor {
        private String signatureClassName;
        private boolean newParameter;

        public SignatureVisitorImpl(int api) {
            super(api);
            this.newParameter = false;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            this.newParameter = true;
            return this;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            this.newParameter = true;
            return this;
        }

        @Override
        public void visitClassType(String name) {
            if (this.signatureClassName == null || this.newParameter) {
                this.signatureClassName = name;
                this.newParameter = false;
            }
            DependencyVisitor.this.addInternalName(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            this.signatureClassName = this.signatureClassName + "$" + name;
            DependencyVisitor.this.addInternalName(this.signatureClassName);
        }
    }

    public class FieldVisitorImpl
    extends FieldVisitor {
        public FieldVisitorImpl(int api) {
            super(api);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return new AnnotationVisitorImpl(327680);
        }
    }

    public class AnnotationVisitorImpl
    extends AnnotationVisitor {
        public AnnotationVisitorImpl(int api) {
            super(api);
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyVisitor.this.addType((Type)value);
            }
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            DependencyVisitor.this.addDesc(desc);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            DependencyVisitor.this.addDesc(desc);
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    public class MethodVisitorImpl
    extends MethodVisitor {
        public MethodVisitorImpl(int api) {
            super(api);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return new AnnotationVisitorImpl(327680);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            DependencyVisitor.this.addType(Type.getObjectType(type));
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.addInternalName(owner);
            DependencyVisitor.this.addDesc(desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.addInternalName(owner);
            DependencyVisitor.this.addMethodDesc(desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DependencyVisitor.this.addInternalName(owner);
            DependencyVisitor.this.addMethodDesc(desc);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                DependencyVisitor.this.addType((Type)cst);
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            DependencyVisitor.this.addDesc(desc);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start2, Label end, int index) {
            if (signature == null) {
                DependencyVisitor.this.addDesc(desc);
            } else {
                DependencyVisitor.this.addTypeSignature(signature);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationVisitorImpl(327680);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return new AnnotationVisitorImpl(327680);
        }

        @Override
        public void visitTryCatchBlock(Label start2, Label end, Label handler, String type) {
            if (type != null) {
                DependencyVisitor.this.addInternalName(type);
            }
        }
    }
}

