/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import org.apache.flink.util.ExceptionUtils;

public final class ClassLoaderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserCodeClassLoaderInfo(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)loader;
            try {
                StringBuilder bld = new StringBuilder();
                if (cl == ClassLoader.getSystemClassLoader()) {
                    bld.append("System ClassLoader: ");
                } else {
                    bld.append("URL ClassLoader:");
                }
                for (URL url : cl.getURLs()) {
                    bld.append("\n    ");
                    if (url == null) {
                        bld.append("(null)");
                        continue;
                    }
                    if ("file".equals(url.getProtocol())) {
                        String filePath = url.getPath();
                        File fileFile = new File(filePath);
                        bld.append("file: '").append(filePath).append('\'');
                        if (fileFile.exists()) {
                            if (fileFile.isDirectory()) {
                                bld.append(" (directory)");
                                continue;
                            }
                            try (JarFile jar = null;){
                                jar = new JarFile(filePath);
                                bld.append(" (valid JAR)");
                                continue;
                            }
                        }
                        bld.append(" (missing)");
                        continue;
                    }
                    bld.append("url: ").append(url);
                }
                return bld.toString();
            }
            catch (Throwable t) {
                return "Cannot access classloader info due to an exception.\n" + ExceptionUtils.stringifyException((Throwable)t);
            }
        }
        return "No user code ClassLoader";
    }

    public static boolean validateClassLoadable(ClassNotFoundException cnfe, ClassLoader cl) {
        try {
            String className = cnfe.getMessage();
            Class.forName(className, false, cl);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ClassLoaderUtil() {
        throw new RuntimeException();
    }
}

