/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.impl.FlinkFuture;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.io.network.netty.PartitionProducerStateChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;

public class ActorGatewayPartitionProducerStateChecker
implements PartitionProducerStateChecker {
    private final ActorGateway jobManager;
    private final FiniteDuration timeout;

    public ActorGatewayPartitionProducerStateChecker(ActorGateway jobManager, FiniteDuration timeout) {
        this.jobManager = (ActorGateway)Preconditions.checkNotNull((Object)jobManager);
        this.timeout = (FiniteDuration)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<ExecutionState> requestPartitionProducerState(JobID jobId, IntermediateDataSetID intermediateDataSetId, ResultPartitionID resultPartitionId) {
        JobManagerMessages.RequestPartitionProducerState msg = new JobManagerMessages.RequestPartitionProducerState(jobId, intermediateDataSetId, resultPartitionId);
        Future futureResponse = this.jobManager.ask(msg, this.timeout).mapTo(ClassTag$.MODULE$.apply(ExecutionState.class));
        return new FlinkFuture<ExecutionState>(futureResponse);
    }
}

