/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationConnectionListener;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class TaskExecutorToResourceManagerConnection
extends RegisteredRpcConnection<ResourceManagerGateway, TaskExecutorRegistrationSuccess> {
    private final RpcService rpcService;
    private final String taskManagerAddress;
    private final ResourceID taskManagerResourceId;
    private final SlotReport slotReport;
    private final RegistrationConnectionListener<TaskExecutorRegistrationSuccess> registrationListener;
    private InstanceID registrationId;
    private ResourceID resourceManagerResourceId;

    public TaskExecutorToResourceManagerConnection(Logger log, RpcService rpcService, String taskManagerAddress, ResourceID taskManagerResourceId, SlotReport slotReport, String resourceManagerAddress, UUID resourceManagerLeaderId, Executor executor, RegistrationConnectionListener<TaskExecutorRegistrationSuccess> registrationListener) {
        super(log, resourceManagerAddress, resourceManagerLeaderId, executor);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.taskManagerAddress = (String)Preconditions.checkNotNull((Object)taskManagerAddress);
        this.taskManagerResourceId = (ResourceID)Preconditions.checkNotNull((Object)taskManagerResourceId);
        this.slotReport = (SlotReport)Preconditions.checkNotNull((Object)slotReport);
        this.registrationListener = (RegistrationConnectionListener)Preconditions.checkNotNull(registrationListener);
    }

    @Override
    protected RetryingRegistration<ResourceManagerGateway, TaskExecutorRegistrationSuccess> generateRegistration() {
        return new ResourceManagerRegistration(this.log, this.rpcService, this.getTargetAddress(), this.getTargetLeaderId(), this.taskManagerAddress, this.taskManagerResourceId, this.slotReport);
    }

    @Override
    protected void onRegistrationSuccess(TaskExecutorRegistrationSuccess success) {
        this.log.info("Successful registration at resource manager {} under registration id {}.", (Object)this.getTargetAddress(), (Object)success.getRegistrationId());
        this.registrationId = success.getRegistrationId();
        this.resourceManagerResourceId = success.getResourceManagerId();
        this.registrationListener.onRegistrationSuccess(success);
    }

    @Override
    protected void onRegistrationFailure(Throwable failure) {
        this.log.info("Failed to register at resource manager {}.", (Object)this.getTargetAddress(), (Object)failure);
        this.registrationListener.onRegistrationFailure(failure);
    }

    public InstanceID getRegistrationId() {
        return this.registrationId;
    }

    public ResourceID getResourceManagerId() {
        return this.resourceManagerResourceId;
    }

    private static class ResourceManagerRegistration
    extends RetryingRegistration<ResourceManagerGateway, TaskExecutorRegistrationSuccess> {
        private final String taskExecutorAddress;
        private final ResourceID resourceID;
        private final SlotReport slotReport;

        ResourceManagerRegistration(Logger log, RpcService rpcService, String targetAddress, UUID leaderId, String taskExecutorAddress, ResourceID resourceID, SlotReport slotReport) {
            super(log, rpcService, "ResourceManager", ResourceManagerGateway.class, targetAddress, leaderId);
            this.taskExecutorAddress = (String)Preconditions.checkNotNull((Object)taskExecutorAddress);
            this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
            this.slotReport = (SlotReport)Preconditions.checkNotNull((Object)slotReport);
        }

        @Override
        protected Future<RegistrationResponse> invokeRegistration(ResourceManagerGateway resourceManager, UUID leaderId, long timeoutMillis) throws Exception {
            Time timeout = Time.milliseconds((long)timeoutMillis);
            return resourceManager.registerTaskExecutor(leaderId, this.taskExecutorAddress, this.resourceID, this.slotReport, timeout);
        }
    }
}

