/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.util.Preconditions;

public class QueryableStateConfiguration {
    private final boolean enabled;
    private final int port;
    private final int numServerThreads;
    private final int numQueryThreads;

    public QueryableStateConfiguration(boolean enabled, int port, int numServerThreads, int numQueryThreads) {
        Preconditions.checkArgument((port >= 0 && port < 65536 ? 1 : 0) != 0, (Object)"queryable state server port out of range");
        Preconditions.checkArgument((numServerThreads >= 0 ? 1 : 0) != 0, (Object)"queryable state number of server threads must be zero or larger");
        Preconditions.checkArgument((numQueryThreads >= 0 ? 1 : 0) != 0, (Object)"queryable state number of query threads must be zero or larger");
        this.enabled = enabled;
        this.port = port;
        this.numServerThreads = numServerThreads;
        this.numQueryThreads = numQueryThreads;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int port() {
        return this.port;
    }

    public int numServerThreads() {
        return this.numServerThreads;
    }

    public int numQueryThreads() {
        return this.numQueryThreads;
    }

    public String toString() {
        return "QueryableStateConfiguration {enabled=" + this.enabled + ", numServerThreads=" + this.numServerThreads + ", numQueryThreads=" + this.numQueryThreads + '}';
    }

    public static QueryableStateConfiguration disabled() {
        return new QueryableStateConfiguration(false, 0, 0, 0);
    }
}

