/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackendFactory;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

@PublicEvolving
public abstract class AbstractStateBackend
implements StateBackend,
Serializable {
    private static final long serialVersionUID = 4620415814639230247L;
    public static final String MEMORY_STATE_BACKEND_NAME = "jobmanager";
    public static final String FS_STATE_BACKEND_NAME = "filesystem";
    public static final String ROCKSDB_STATE_BACKEND_NAME = "rocksdb";

    @Override
    public abstract CheckpointStreamFactory createStreamFactory(JobID var1, String var2) throws IOException;

    @Override
    public abstract CheckpointStreamFactory createSavepointStreamFactory(JobID var1, String var2, @Nullable String var3) throws IOException;

    @Override
    public abstract <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment var1, JobID var2, String var3, TypeSerializer<K> var4, int var5, KeyGroupRange var6, TaskKvStateRegistry var7) throws IOException;

    @Override
    public abstract OperatorStateBackend createOperatorStateBackend(Environment var1, String var2) throws Exception;

    public static StateBackend loadStateBackendFromConfig(Configuration config, ClassLoader classLoader, @Nullable Logger logger) throws IllegalConfigurationException, DynamicCodeLoadingException, IOException {
        StateBackendFactory factory;
        Preconditions.checkNotNull((Object)config, (String)"config");
        Preconditions.checkNotNull((Object)classLoader, (String)"classLoader");
        String backendName = config.getString(CoreOptions.STATE_BACKEND);
        if (backendName == null) {
            return null;
        }
        String factoryClassName = backendName;
        switch (backendName.toLowerCase()) {
            case "jobmanager": {
                if (logger != null) {
                    logger.info("State backend is set to heap memory (checkpoint to JobManager)");
                }
                return new MemoryStateBackend();
            }
            case "filesystem": {
                FsStateBackend fsBackend = new FsStateBackendFactory().createFromConfig(config);
                if (logger != null) {
                    logger.info("State backend is set to heap memory (checkpoints to filesystem \"{}\")", (Object)fsBackend.getBasePath());
                }
                return fsBackend;
            }
            case "rocksdb": {
                factoryClassName = "org.apache.flink.contrib.streaming.state.RocksDBStateBackendFactory";
            }
        }
        if (logger != null) {
            logger.info("Loading state backend via factory {}", (Object)factoryClassName);
        }
        try {
            Class<StateBackendFactory> clazz = Class.forName(factoryClassName, false, classLoader).asSubclass(StateBackendFactory.class);
            factory = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicCodeLoadingException("Cannot find configured state backend factory class: " + backendName, (Throwable)e);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new DynamicCodeLoadingException("The class configured under '" + CoreOptions.STATE_BACKEND.key() + "' is not a valid state backend factory (" + backendName + ')', (Throwable)e);
        }
        return factory.createFromConfig(config);
    }

    public static StateBackend loadStateBackendFromConfigOrCreateDefault(Configuration config, ClassLoader classLoader, @Nullable Logger logger) throws IllegalConfigurationException, DynamicCodeLoadingException, IOException {
        StateBackend fromConfig = AbstractStateBackend.loadStateBackendFromConfig(config, classLoader, logger);
        if (fromConfig != null) {
            return fromConfig;
        }
        if (logger != null) {
            logger.info("No state backend has been configured, using default state backend (Memory / JobManager)");
        }
        return new MemoryStateBackend();
    }
}

