/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.UserGroupInformation;

class HadoopSecurityContext
implements SecurityContext {
    private UserGroupInformation ugi;

    HadoopSecurityContext(UserGroupInformation ugi) {
        this.ugi = (UserGroupInformation)Preconditions.checkNotNull((Object)ugi, (String)"UGI passed cannot be null");
    }

    @Override
    public <T> T runSecured(final Callable<T> securedCallable) throws Exception {
        return (T)this.ugi.doAs(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                return securedCallable.call();
            }
        });
    }
}

