/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.rpc.MainThreadExecutable;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.SelfGateway;
import org.apache.flink.runtime.rpc.StartStoppable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcEndpoint<C extends RpcGateway> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RpcService rpcService;
    private final String endpointId;
    private final Class<C> selfGatewayType;
    private final C self;
    private final Executor mainThreadExecutor;
    final AtomicReference<Thread> currentMainThread = new AtomicReference<Object>(null);

    protected RpcEndpoint(RpcService rpcService, String endpointId) {
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService, (String)"rpcService");
        this.endpointId = (String)Preconditions.checkNotNull((Object)endpointId, (String)"endpointId");
        this.selfGatewayType = this.determineSelfGatewayType();
        this.self = rpcService.startServer(this);
        this.mainThreadExecutor = new MainThreadExecutor((MainThreadExecutable)this.self);
    }

    protected RpcEndpoint(RpcService rpcService) {
        this(rpcService, UUID.randomUUID().toString());
    }

    public final Class<C> getSelfGatewayType() {
        return this.selfGatewayType;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void start() throws Exception {
        ((StartStoppable)this.self).start();
    }

    public void shutDown() throws Exception {
        this.rpcService.stopServer(this.self);
    }

    public C getSelf() {
        return this.self;
    }

    public String getAddress() {
        return this.self.getAddress();
    }

    protected Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public Future<Void> getTerminationFuture() {
        return ((SelfGateway)this.self).getTerminationFuture();
    }

    protected void runAsync(Runnable runnable) {
        ((MainThreadExecutable)this.self).runAsync(runnable);
    }

    protected void scheduleRunAsync(Runnable runnable, Time delay) {
        this.scheduleRunAsync(runnable, delay.getSize(), delay.getUnit());
    }

    protected void scheduleRunAsync(Runnable runnable, long delay, TimeUnit unit) {
        ((MainThreadExecutable)this.self).scheduleRunAsync(runnable, unit.toMillis(delay));
    }

    protected <V> Future<V> callAsync(Callable<V> callable, Time timeout) {
        return ((MainThreadExecutable)this.self).callAsync(callable, timeout);
    }

    public void validateRunsInMainThread() {
        assert (this.currentMainThread.get() == Thread.currentThread());
    }

    private Class<C> determineSelfGatewayType() {
        Class determinedSelfGatewayType;
        Class<?> c = this.getClass();
        do {
            determinedSelfGatewayType = ReflectionUtil.getTemplateType1(c);
            c = c.getSuperclass();
        } while (!RpcGateway.class.isAssignableFrom(determinedSelfGatewayType));
        return determinedSelfGatewayType;
    }

    private static class MainThreadExecutor
    implements Executor {
        private final MainThreadExecutable gateway;

        MainThreadExecutor(MainThreadExecutable gateway) {
            this.gateway = (MainThreadExecutable)Preconditions.checkNotNull((Object)gateway);
        }

        @Override
        public void execute(@Nonnull Runnable runnable) {
            this.gateway.runAsync(runnable);
        }
    }
}

