/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.Duration;

public class ResourceManagerConfiguration {
    private final Time timeout;
    private final Time heartbeatInterval;

    public ResourceManagerConfiguration(Time timeout, Time heartbeatInterval) {
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout, (String)"timeout");
        this.heartbeatInterval = (Time)Preconditions.checkNotNull((Object)heartbeatInterval, (String)"heartbeatInterval");
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public Time getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public static ResourceManagerConfiguration fromConfiguration(Configuration configuration) throws ConfigurationException {
        Time heartbeatInterval;
        Time timeout;
        String strTimeout = configuration.getString(AkkaOptions.AKKA_ASK_TIMEOUT);
        try {
            timeout = Time.milliseconds((long)Duration.apply((String)strTimeout).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's timeout value " + AkkaOptions.AKKA_ASK_TIMEOUT + '.', (Throwable)e);
        }
        String strHeartbeatInterval = configuration.getString(AkkaOptions.AKKA_WATCH_HEARTBEAT_INTERVAL);
        try {
            heartbeatInterval = Time.milliseconds((long)Duration.apply((String)strHeartbeatInterval).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's heartbeat interval value " + AkkaOptions.AKKA_WATCH_HEARTBEAT_INTERVAL + '.', (Throwable)e);
        }
        return new ResourceManagerConfiguration(timeout, heartbeatInterval);
    }
}

