/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import org.apache.flink.runtime.query.netty.KvStateClientHandlerCallback;
import org.apache.flink.runtime.query.netty.message.KvStateRequestFailure;
import org.apache.flink.runtime.query.netty.message.KvStateRequestResult;
import org.apache.flink.runtime.query.netty.message.KvStateRequestSerializer;
import org.apache.flink.runtime.query.netty.message.KvStateRequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KvStateClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KvStateClientHandler.class);
    private final KvStateClientHandlerCallback callback;

    KvStateClientHandler(KvStateClientHandlerCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block10: {
            try {
                ByteBuf buf = (ByteBuf)msg;
                KvStateRequestType msgType = KvStateRequestSerializer.deserializeHeader(buf);
                if (msgType == KvStateRequestType.REQUEST_RESULT) {
                    KvStateRequestResult result = KvStateRequestSerializer.deserializeKvStateRequestResult(buf);
                    this.callback.onRequestResult(result.getRequestId(), result.getSerializedResult());
                    break block10;
                }
                if (msgType == KvStateRequestType.REQUEST_FAILURE) {
                    KvStateRequestFailure failure = KvStateRequestSerializer.deserializeKvStateRequestFailure(buf);
                    this.callback.onRequestFailure(failure.getRequestId(), failure.getCause());
                    break block10;
                }
                if (msgType == KvStateRequestType.SERVER_FAILURE) {
                    throw KvStateRequestSerializer.deserializeServerFailure(buf);
                }
                throw new IllegalStateException("Unexpected response type '" + (Object)((Object)msgType) + "'");
            }
            catch (Throwable t1) {
                try {
                    this.callback.onFailure(t1);
                }
                catch (Throwable t2) {
                    LOG.error("Failed to notify callback about failure", t2);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            this.callback.onFailure(cause);
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.callback.onFailure(new ClosedChannelException());
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }
}

