/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class MiniClusterConfiguration {
    private final Configuration config;
    private boolean singleRpcService = true;
    private int numJobManagers = 1;
    private int numTaskManagers = 1;
    private int numResourceManagers = 1;
    private String commonBindAddress;
    private long managedMemoryPerTaskManager = -1L;

    public MiniClusterConfiguration() {
        this.config = new Configuration();
    }

    public MiniClusterConfiguration(Configuration config) {
        Preconditions.checkNotNull((Object)config);
        this.config = new Configuration(config);
    }

    public void addConfiguration(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"configuration must not be null");
        this.config.addAll(config);
    }

    public void setUseSingleRpcService() {
        this.singleRpcService = true;
    }

    public void setUseRpcServicePerComponent() {
        this.singleRpcService = false;
    }

    public void setNumJobManagers(int numJobManagers) {
        Preconditions.checkArgument((numJobManagers >= 1 ? 1 : 0) != 0, (Object)"must have at least one JobManager");
        this.numJobManagers = numJobManagers;
    }

    public void setNumTaskManagers(int numTaskManagers) {
        Preconditions.checkArgument((numTaskManagers >= 1 ? 1 : 0) != 0, (Object)"must have at least one TaskManager");
        this.numTaskManagers = numTaskManagers;
    }

    public void setNumResourceManagers(int numResourceManagers) {
        Preconditions.checkArgument((numResourceManagers >= 1 ? 1 : 0) != 0, (Object)"must have at least one ResourceManager");
        this.numResourceManagers = numResourceManagers;
    }

    public void setNumTaskManagerSlots(int numTaskSlots) {
        Preconditions.checkArgument((numTaskSlots >= 1 ? 1 : 0) != 0, (Object)"must have at least one task slot per TaskManager");
        this.config.setInteger("taskmanager.numberOfTaskSlots", numTaskSlots);
    }

    public void setCommonRpcBindAddress(String bindAddress) {
        Preconditions.checkNotNull((Object)bindAddress, (String)"bind address must not be null");
        this.commonBindAddress = bindAddress;
    }

    public void setManagedMemoryPerTaskManager(long managedMemoryPerTaskManager) {
        Preconditions.checkArgument((managedMemoryPerTaskManager > 0L ? 1 : 0) != 0, (Object)"must have more than 0 MB of memory for the TaskManager.");
        this.managedMemoryPerTaskManager = managedMemoryPerTaskManager;
    }

    public boolean getUseSingleRpcSystem() {
        return this.singleRpcService;
    }

    public int getNumJobManagers() {
        return this.numJobManagers;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public int getNumResourceManagers() {
        return this.numResourceManagers;
    }

    public int getNumSlotsPerTaskManager() {
        return this.config.getInteger("taskmanager.numberOfTaskSlots", 1);
    }

    public String getJobManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.config.getString("jobmanager.rpc.address", "localhost");
    }

    public String getTaskManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.config.getString("taskmanager.hostname", "localhost");
    }

    public String getResourceManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.config.getString("jobmanager.rpc.address", "localhost");
    }

    public Time getRpcTimeout() {
        FiniteDuration duration = AkkaUtils.getTimeout(this.config);
        return Time.of((long)duration.length(), (TimeUnit)duration.unit());
    }

    public long getManagedMemoryPerTaskManager() {
        return this.getOrCalculateManagedMemoryPerTaskManager();
    }

    public Configuration generateConfiguration() {
        Configuration newConfiguration = new Configuration(this.config);
        long memory = this.getOrCalculateManagedMemoryPerTaskManager();
        newConfiguration.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, memory);
        return newConfiguration;
    }

    public String toString() {
        return "MiniClusterConfiguration {singleRpcService=" + this.singleRpcService + ", numJobManagers=" + this.numJobManagers + ", numTaskManagers=" + this.numTaskManagers + ", numResourceManagers=" + this.numResourceManagers + ", commonBindAddress='" + this.commonBindAddress + '\'' + ", config=" + this.config + '}';
    }

    private long getOrCalculateManagedMemoryPerTaskManager() {
        if (this.managedMemoryPerTaskManager == -1L) {
            long memorySize = this.config.getLong(TaskManagerOptions.MANAGED_MEMORY_SIZE);
            if (memorySize == (Long)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue()) {
                float memoryFraction = this.config.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
                long freeMemory = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
                long memoryPerComponent = freeMemory / (long)(this.numTaskManagers + this.numResourceManagers + this.numJobManagers);
                long networkBuffersMemory = TaskManagerServices.calculateNetworkBufferMemory(memoryPerComponent, this.config);
                long memoryMinusNetworkBuffers = memoryPerComponent - networkBuffersMemory;
                long managedMemoryBytes = (long)((float)memoryMinusNetworkBuffers * memoryFraction);
                return managedMemoryBytes >> 20;
            }
            return memorySize;
        }
        return this.managedMemoryPerTaskManager;
    }
}

