/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.AbstractNonHaServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class EmbeddedHaServices
extends AbstractNonHaServices {
    private final Executor executor;
    private final EmbeddedLeaderService resourceManagerLeaderService;
    private final HashMap<JobID, EmbeddedLeaderService> jobManagerLeaderServices;

    public EmbeddedHaServices(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.resourceManagerLeaderService = new EmbeddedLeaderService(executor);
        this.jobManagerLeaderServices = new HashMap();
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return this.resourceManagerLeaderService.createLeaderRetrievalService();
    }

    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        return this.resourceManagerLeaderService.createLeaderElectionService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        Preconditions.checkNotNull((Object)jobID);
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            EmbeddedLeaderService service = this.getOrCreateJobManagerService(jobID);
            return service.createLeaderRetrievalService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        Preconditions.checkNotNull((Object)jobID);
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            EmbeddedLeaderService service = this.getOrCreateJobManagerService(jobID);
            return service.createLeaderElectionService();
        }
    }

    @GuardedBy(value="lock")
    private EmbeddedLeaderService getOrCreateJobManagerService(JobID jobID) {
        EmbeddedLeaderService service = this.jobManagerLeaderServices.get(jobID);
        if (service == null) {
            service = new EmbeddedLeaderService(this.executor);
            this.jobManagerLeaderServices.put(jobID, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isShutDown()) {
                for (EmbeddedLeaderService service : this.jobManagerLeaderServices.values()) {
                    service.shutdown();
                }
                this.jobManagerLeaderServices.clear();
                this.resourceManagerLeaderService.shutdown();
            }
            super.close();
        }
    }
}

