/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import javax.annotation.Nonnull;

public class ResourceProfile
implements Serializable,
Comparable<ResourceProfile> {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile(-1.0, -1);
    private final double cpuCores;
    private final int heapMemoryInMB;
    private final int directMemoryInMB;
    private final int nativeMemoryInMB;

    public ResourceProfile(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
    }

    public ResourceProfile(double cpuCores, int heapMemoryInMB) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = 0;
        this.nativeMemoryInMB = 0;
    }

    public ResourceProfile(ResourceProfile other) {
        this.cpuCores = other.cpuCores;
        this.heapMemoryInMB = other.heapMemoryInMB;
        this.directMemoryInMB = other.directMemoryInMB;
        this.nativeMemoryInMB = other.nativeMemoryInMB;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public long getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    public int getMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB;
    }

    public boolean isMatching(ResourceProfile required) {
        return this.cpuCores >= required.getCpuCores() && (long)this.heapMemoryInMB >= required.getHeapMemoryInMB() && this.directMemoryInMB >= required.getDirectMemoryInMB() && this.nativeMemoryInMB >= required.getNativeMemoryInMB();
    }

    @Override
    public int compareTo(@Nonnull ResourceProfile other) {
        int cmp1 = Integer.compare(this.getMemoryInMB(), other.getMemoryInMB());
        int cmp2 = Double.compare(this.cpuCores, other.cpuCores);
        return cmp1 != 0 ? cmp1 : cmp2;
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB;
        }
        return false;
    }

    public String toString() {
        return "ResourceProfile{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + '}';
    }
}

