/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.dispatch.Futures;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.client.JobClientActor;
import org.apache.flink.runtime.client.JobClientActorSubmissionTimeoutException;
import org.apache.flink.runtime.client.JobSubmissionException;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobClientMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.util.SerializedThrowable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class JobSubmissionClientActor
extends JobClientActor {
    private JobGraph jobGraph;
    private boolean jobSuccessfullySubmitted = false;
    private final Configuration clientConfig;

    public JobSubmissionClientActor(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates, Configuration clientConfig) {
        super(leaderRetrievalService, timeout, sysoutUpdates);
        this.clientConfig = clientConfig;
    }

    @Override
    public void connectedToJobManager() {
        if (this.jobGraph != null && !this.jobSuccessfullySubmitted) {
            this.tryToSubmitJob();
        }
    }

    @Override
    protected Class getClientMessageClass() {
        return JobClientMessages.SubmitJobAndWait.class;
    }

    @Override
    public void handleCustomMessage(Object message) {
        if (message instanceof JobClientMessages.SubmitJobAndWait) {
            if (this.client == null) {
                this.jobGraph = ((JobClientMessages.SubmitJobAndWait)message).jobGraph();
                if (this.jobGraph == null) {
                    this.LOG.error("Received null JobGraph");
                    this.sender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception("JobGraph is null"))), this.getSelf());
                } else {
                    this.LOG.info("Received job {} ({}).", (Object)this.jobGraph.getName(), (Object)this.jobGraph.getJobID());
                    this.client = this.getSender();
                    if (this.jobManager != null) {
                        this.tryToSubmitJob();
                    }
                }
            } else {
                String msg = "Received repeated 'SubmitJobAndWait'";
                this.LOG.error(msg);
                this.getSender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception(msg))), ActorRef.noSender());
                this.terminate();
            }
        } else if (message instanceof JobManagerMessages.JobSubmitSuccess) {
            this.LOG.info("Job {} was successfully submitted to the JobManager {}.", (Object)((JobManagerMessages.JobSubmitSuccess)message).jobId(), (Object)this.getSender().path());
            this.jobSuccessfullySubmitted = true;
        } else if (JobClientMessages.getSubmissionTimeout().equals(message)) {
            if (!this.jobSuccessfullySubmitted) {
                if (this.isClientConnected()) {
                    this.client.tell(this.decorateMessage(new Status.Failure((Throwable)new JobClientActorSubmissionTimeoutException("Job submission to the JobManager timed out. You may increase 'akka.client.timeout' in case the JobManager needs more time to configure and confirm the job submission."))), this.getSelf());
                }
                this.terminate();
            }
        } else {
            this.LOG.error("{} received unknown message: ", this.getClass());
        }
    }

    private void tryToSubmitJob() {
        this.LOG.info("Sending message to JobManager {} to submit job {} ({}) and wait for progress", new Object[]{this.jobManager.path().toString(), this.jobGraph.getName(), this.jobGraph.getJobID()});
        Futures.future((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AkkaActorGateway jobManagerGateway = new AkkaActorGateway(JobSubmissionClientActor.this.jobManager, JobSubmissionClientActor.this.leaderSessionID);
                JobSubmissionClientActor.this.LOG.info("Upload jar files to job manager {}.", (Object)JobSubmissionClientActor.this.jobManager.path());
                try {
                    JobSubmissionClientActor.this.jobGraph.uploadUserJars(jobManagerGateway, JobSubmissionClientActor.this.timeout, JobSubmissionClientActor.this.clientConfig);
                }
                catch (IOException exception) {
                    JobSubmissionClientActor.this.getSelf().tell(JobSubmissionClientActor.this.decorateMessage(new JobManagerMessages.JobResultFailure(new SerializedThrowable(new JobSubmissionException(JobSubmissionClientActor.this.jobGraph.getJobID(), "Could not upload the jar files to the job manager.", exception)))), ActorRef.noSender());
                }
                JobSubmissionClientActor.this.LOG.info("Submit job to the job manager {}.", (Object)JobSubmissionClientActor.this.jobManager.path());
                JobSubmissionClientActor.this.jobManager.tell(JobSubmissionClientActor.this.decorateMessage(new JobManagerMessages.SubmitJob(JobSubmissionClientActor.this.jobGraph, ListeningBehaviour.EXECUTION_RESULT_AND_STATE_CHANGES)), JobSubmissionClientActor.this.getSelf());
                JobSubmissionClientActor.this.getContext().system().scheduler().scheduleOnce(JobSubmissionClientActor.this.timeout, JobSubmissionClientActor.this.getSelf(), JobSubmissionClientActor.this.decorateMessage(JobClientMessages.getSubmissionTimeout()), (ExecutionContext)JobSubmissionClientActor.this.getContext().dispatcher(), ActorRef.noSender());
                return null;
            }
        }, (ExecutionContext)this.getContext().dispatcher());
    }

    public static Props createActorProps(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates, Configuration clientConfig) {
        return Props.create(JobSubmissionClientActor.class, (Object[])new Object[]{leaderRetrievalService, timeout, sysoutUpdates, clientConfig});
    }
}

