/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobRetrievalException;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public final class JobListeningContext {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final JobID jobID;
    private final Future<Object> jobResultFuture;
    private final ActorRef jobClientActor;
    private final FiniteDuration timeout;
    private final HighAvailabilityServices highAvailabilityServices;
    private ActorSystem actorSystem;
    private Configuration configuration;
    private ClassLoader classLoader;

    public JobListeningContext(JobID jobID, Future<Object> jobResultFuture, ActorRef jobClientActor, FiniteDuration timeout, ClassLoader classLoader, HighAvailabilityServices highAvailabilityServices) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.jobResultFuture = (Future)Preconditions.checkNotNull(jobResultFuture);
        this.jobClientActor = (ActorRef)Preconditions.checkNotNull((Object)jobClientActor);
        this.timeout = (FiniteDuration)Preconditions.checkNotNull((Object)timeout);
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityServices, (String)"highAvailabilityServices");
    }

    public JobListeningContext(JobID jobID, Future<Object> jobResultFuture, ActorRef jobClientActor, FiniteDuration timeout, ActorSystem actorSystem, Configuration configuration, HighAvailabilityServices highAvailabilityServices) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.jobResultFuture = (Future)Preconditions.checkNotNull(jobResultFuture);
        this.jobClientActor = (ActorRef)Preconditions.checkNotNull((Object)jobClientActor);
        this.timeout = (FiniteDuration)Preconditions.checkNotNull((Object)timeout);
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityServices, (String)"highAvailabilityServices");
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Future<Object> getJobResultFuture() {
        return this.jobResultFuture;
    }

    public ActorRef getJobClientActor() {
        return this.jobClientActor;
    }

    public FiniteDuration getTimeout() {
        return this.timeout;
    }

    public ClassLoader getClassLoader() throws JobRetrievalException {
        if (this.classLoader == null) {
            this.classLoader = JobClient.retrieveClassLoader(this.jobID, this.getJobManager(), this.configuration, this.highAvailabilityServices);
            this.LOG.info("Reconstructed class loader for Job {}", (Object)this.jobID);
        }
        return this.classLoader;
    }

    private ActorGateway getJobManager() throws JobRetrievalException {
        try {
            return LeaderRetrievalUtils.retrieveLeaderGateway(this.highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), this.actorSystem, AkkaUtils.getLookupTimeout(this.configuration));
        }
        catch (Exception e) {
            throw new JobRetrievalException(this.jobID, "Couldn't retrieve leading JobManager.", e);
        }
    }
}

