/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.Preconditions;

@Deprecated
public class TaskState
implements CompositeStateHandle {
    private static final long serialVersionUID = -4845578005863201810L;
    private final JobVertexID jobVertexID;
    private final Map<Integer, SubtaskState> subtaskStates;
    private final int parallelism;
    private final int maxParallelism;
    private final int chainLength;

    public TaskState(JobVertexID jobVertexID, int parallelism, int maxParallelism, int chainLength) {
        Preconditions.checkArgument((parallelism <= maxParallelism ? 1 : 0) != 0, (Object)("Parallelism " + parallelism + " is not smaller or equal to max parallelism " + maxParallelism + "."));
        Preconditions.checkArgument((chainLength > 0 ? 1 : 0) != 0, (Object)"There has to be at least one operator in the operator chain.");
        this.jobVertexID = jobVertexID;
        this.subtaskStates = new HashMap<Integer, SubtaskState>(parallelism);
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
        this.chainLength = chainLength;
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public void putState(int subtaskIndex, SubtaskState subtaskState) {
        Preconditions.checkNotNull((Object)subtaskState);
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.subtaskStates.size());
        }
        this.subtaskStates.put(subtaskIndex, subtaskState);
    }

    public SubtaskState getState(int subtaskIndex) {
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.subtaskStates.size());
        }
        return this.subtaskStates.get(subtaskIndex);
    }

    public Collection<SubtaskState> getStates() {
        return this.subtaskStates.values();
    }

    public int getNumberCollectedStates() {
        return this.subtaskStates.size();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getChainLength() {
        return this.chainLength;
    }

    public boolean hasNonPartitionedState() {
        for (SubtaskState sts : this.subtaskStates.values()) {
            if (sts == null || sts.getLegacyOperatorState().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void discardState() throws Exception {
        for (SubtaskState subtaskState : this.subtaskStates.values()) {
            subtaskState.discardState();
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        for (SubtaskState subtaskState : this.subtaskStates.values()) {
            subtaskState.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        long result = 0L;
        for (int i = 0; i < this.parallelism; ++i) {
            SubtaskState subtaskState = this.subtaskStates.get(i);
            if (subtaskState == null) continue;
            result += subtaskState.getStateSize();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskState) {
            TaskState other = (TaskState)obj;
            return this.jobVertexID.equals((Object)other.jobVertexID) && this.parallelism == other.parallelism && this.subtaskStates.equals(other.subtaskStates);
        }
        return false;
    }

    public int hashCode() {
        return this.parallelism + 31 * Objects.hash(new Object[]{this.jobVertexID, this.subtaskStates});
    }

    public Map<Integer, SubtaskState> getSubtaskStates() {
        return Collections.unmodifiableMap(this.subtaskStates);
    }

    public String toString() {
        return "TaskState(jobVertexID: " + (Object)((Object)this.jobVertexID) + ", parallelism: " + this.parallelism + ", sub task states: " + this.subtaskStates.size() + ", total size (bytes): " + this.getStateSize() + ')';
    }
}

