/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;

public class CheckpointProperties
implements Serializable {
    private static final long serialVersionUID = -8835900655844879469L;
    private final boolean forced;
    private final boolean externalize;
    private final boolean discardSubsumed;
    private final boolean discardFinished;
    private final boolean discardCancelled;
    private final boolean discardFailed;
    private final boolean discardSuspended;
    private static final CheckpointProperties STANDARD_SAVEPOINT = new CheckpointProperties(true, true, false, false, false, false, false);
    private static final CheckpointProperties STANDARD_CHECKPOINT = new CheckpointProperties(false, false, true, true, true, true, true);
    private static final CheckpointProperties EXTERNALIZED_CHECKPOINT_RETAINED = new CheckpointProperties(false, true, true, true, false, false, false);
    private static final CheckpointProperties EXTERNALIZED_CHECKPOINT_DELETED = new CheckpointProperties(false, true, true, true, true, false, true);

    CheckpointProperties(boolean forced, boolean externalize, boolean discardSubsumed, boolean discardFinished, boolean discardCancelled, boolean discardFailed, boolean discardSuspended) {
        this.forced = forced;
        this.externalize = externalize;
        this.discardSubsumed = discardSubsumed;
        this.discardFinished = discardFinished;
        this.discardCancelled = discardCancelled;
        this.discardFailed = discardFailed;
        this.discardSuspended = discardSuspended;
        if (!(externalize || discardSubsumed && discardFinished && discardCancelled && discardFailed && discardSuspended)) {
            throw new IllegalStateException("CheckpointProperties say to *not* persist the checkpoint, but the checkpoint requires manual cleanup.");
        }
    }

    boolean forceCheckpoint() {
        return this.forced;
    }

    boolean externalizeCheckpoint() {
        return this.externalize;
    }

    boolean discardOnSubsumed() {
        return this.discardSubsumed;
    }

    boolean discardOnJobFinished() {
        return this.discardFinished;
    }

    boolean discardOnJobCancelled() {
        return this.discardCancelled;
    }

    boolean discardOnJobFailed() {
        return this.discardFailed;
    }

    boolean discardOnJobSuspended() {
        return this.discardSuspended;
    }

    public boolean isSavepoint() {
        return this == STANDARD_SAVEPOINT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointProperties that = (CheckpointProperties)o;
        return this.forced == that.forced && this.externalize == that.externalize && this.discardSubsumed == that.discardSubsumed && this.discardFinished == that.discardFinished && this.discardCancelled == that.discardCancelled && this.discardFailed == that.discardFailed && this.discardSuspended == that.discardSuspended;
    }

    public int hashCode() {
        int result = this.forced ? 1 : 0;
        result = 31 * result + (this.externalize ? 1 : 0);
        result = 31 * result + (this.discardSubsumed ? 1 : 0);
        result = 31 * result + (this.discardFinished ? 1 : 0);
        result = 31 * result + (this.discardCancelled ? 1 : 0);
        result = 31 * result + (this.discardFailed ? 1 : 0);
        result = 31 * result + (this.discardSuspended ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CheckpointProperties{forced=" + this.forced + ", externalize=" + this.externalizeCheckpoint() + ", discardSubsumed=" + this.discardSubsumed + ", discardFinished=" + this.discardFinished + ", discardCancelled=" + this.discardCancelled + ", discardFailed=" + this.discardFailed + ", discardSuspended=" + this.discardSuspended + '}';
    }

    public static CheckpointProperties forStandardSavepoint() {
        return STANDARD_SAVEPOINT;
    }

    public static CheckpointProperties forStandardCheckpoint() {
        return STANDARD_CHECKPOINT;
    }

    public static CheckpointProperties forExternalizedCheckpoint(boolean deleteOnCancellation) {
        if (deleteOnCancellation) {
            return EXTERNALIZED_CHECKPOINT_DELETED;
        }
        return EXTERNALIZED_CHECKPOINT_RETAINED;
    }
}

