/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    private static final long serialVersionUID = 5010126558083292915L;
    @Nonnull
    private final CheckpointType checkpointType;
    @Nullable
    private final String targetLocation;
    private static final CheckpointOptions FULL_CHECKPOINT = new CheckpointOptions(CheckpointType.FULL_CHECKPOINT, null);

    private CheckpointOptions(@Nonnull CheckpointType checkpointType, @Nullable String targetLocation) {
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = targetLocation;
    }

    @Nonnull
    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    @Nullable
    public String getTargetLocation() {
        return this.targetLocation;
    }

    public String toString() {
        return "CheckpointOptions(" + (Object)((Object)this.checkpointType) + ")";
    }

    public static CheckpointOptions forFullCheckpoint() {
        return FULL_CHECKPOINT;
    }

    public static CheckpointOptions forSavepoint(String targetDirectory) {
        Preconditions.checkNotNull((Object)targetDirectory, (String)"targetDirectory");
        return new CheckpointOptions(CheckpointType.SAVEPOINT, targetDirectory);
    }

    public static enum CheckpointType {
        FULL_CHECKPOINT,
        SAVEPOINT;

    }
}

