/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBlobStore
implements BlobStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBlobStore.class);
    private final FileSystem fileSystem;
    private final String basePath;

    public FileSystemBlobStore(FileSystem fileSystem, String storagePath) throws IOException {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.basePath = (String)Preconditions.checkNotNull((Object)storagePath) + "/blob";
        LOG.info("Creating highly available BLOB storage directory at {}", (Object)this.basePath);
        fileSystem.mkdirs(new Path(this.basePath));
        LOG.debug("Created highly available BLOB storage directory at {}", (Object)this.basePath);
    }

    @Override
    public void put(File localFile, BlobKey blobKey) throws IOException {
        this.put(localFile, BlobUtils.getRecoveryPath(this.basePath, blobKey));
    }

    @Override
    public void put(File localFile, JobID jobId, String key) throws IOException {
        this.put(localFile, BlobUtils.getRecoveryPath(this.basePath, jobId, key));
    }

    private void put(File fromFile, String toBlobPath) throws IOException {
        try (FSDataOutputStream os = this.fileSystem.create(new Path(toBlobPath), true);){
            LOG.debug("Copying from {} to {}.", (Object)fromFile, (Object)toBlobPath);
            Files.copy(fromFile, (OutputStream)os);
        }
    }

    @Override
    public void get(BlobKey blobKey, File localFile) throws IOException {
        this.get(BlobUtils.getRecoveryPath(this.basePath, blobKey), localFile);
    }

    @Override
    public void get(JobID jobId, String key, File localFile) throws IOException {
        this.get(BlobUtils.getRecoveryPath(this.basePath, jobId, key), localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(String fromBlobPath, File toFile) throws IOException {
        Preconditions.checkNotNull((Object)fromBlobPath, (String)"Blob path");
        Preconditions.checkNotNull((Object)toFile, (String)"File");
        if (!toFile.exists() && !toFile.createNewFile()) {
            throw new IOException("Failed to create target file to copy to");
        }
        Path fromPath = new Path(fromBlobPath);
        boolean success = false;
        try (FSDataInputStream is = this.fileSystem.open(fromPath);
             FileOutputStream fos = new FileOutputStream(toFile);){
            LOG.debug("Copying from {} to {}.", (Object)fromBlobPath, (Object)toFile);
            IOUtils.copyBytes((InputStream)is, (OutputStream)fos);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    toFile.delete();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void delete(BlobKey blobKey) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, blobKey));
    }

    @Override
    public void delete(JobID jobId, String key) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, jobId, key));
    }

    @Override
    public void deleteAll(JobID jobId) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, jobId));
    }

    private void delete(String blobPath) {
        try {
            LOG.debug("Deleting {}.", (Object)blobPath);
            Path path = new Path(blobPath);
            this.fileSystem.delete(path, true);
            try {
                this.fileSystem.delete(path.getParent(), false);
                this.fileSystem.delete(new Path(this.basePath), false);
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            LOG.warn("Failed to delete blob at " + blobPath);
        }
    }

    @Override
    public void closeAndCleanupAllData() {
        try {
            LOG.debug("Cleaning up {}.", (Object)this.basePath);
            this.fileSystem.delete(new Path(this.basePath), true);
        }
        catch (Exception e) {
            LOG.error("Failed to clean up recovery directory.", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

