/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.InstantiationUtil;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final ActorGateway jobManager;
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final ExecutionAttemptID executionID;
    private final ClassLoader usercodeClassLoader;
    private final FiniteDuration timeout;

    public TaskInputSplitProvider(ActorGateway jobManager, JobID jobId, JobVertexID vertexId, ExecutionAttemptID executionID, ClassLoader userCodeClassLoader, FiniteDuration timeout) {
        this.jobManager = jobManager;
        this.jobId = jobId;
        this.vertexId = vertexId;
        this.executionID = executionID;
        this.usercodeClassLoader = userCodeClassLoader;
        this.timeout = timeout;
    }

    @Override
    public InputSplit getNextInputSplit() {
        try {
            Future<Object> response = this.jobManager.ask(new JobManagerMessages.RequestNextInputSplit(this.jobId, this.vertexId, this.executionID), this.timeout);
            Object result = Await.result(response, (Duration)this.timeout);
            if (!(result instanceof JobManagerMessages.NextInputSplit)) {
                throw new RuntimeException("RequestNextInputSplit requires a response of type NextInputSplit. Instead response is of type " + result.getClass() + ".");
            }
            JobManagerMessages.NextInputSplit nextInputSplit = (JobManagerMessages.NextInputSplit)result;
            byte[] serializedData = nextInputSplit.splitData();
            if (serializedData == null) {
                return null;
            }
            Object deserialized = InstantiationUtil.deserializeObject((byte[])serializedData, (ClassLoader)this.usercodeClassLoader);
            return (InputSplit)deserialized;
        }
        catch (Exception e) {
            throw new RuntimeException("Requesting the next InputSplit failed.", e);
        }
    }
}

