/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.memory.AbstractMemState;
import org.apache.flink.runtime.state.memory.AbstractMemStateSnapshot;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;

public class MemFoldingState<K, N, T, ACC>
extends AbstractMemState<K, N, ACC, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>>
implements FoldingState<T, ACC> {
    private final FoldFunction<T, ACC> foldFunction;

    public MemFoldingState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, FoldingStateDescriptor<T, ACC> stateDesc) {
        super(keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc);
        this.foldFunction = stateDesc.getFoldFunction();
    }

    public MemFoldingState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, FoldingStateDescriptor<T, ACC> stateDesc, HashMap<N, Map<K, ACC>> state) {
        super(keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc, state);
        this.foldFunction = stateDesc.getFoldFunction();
    }

    public ACC get() {
        if (this.currentNSState == null) {
            this.currentNSState = (Map)this.state.get(this.currentNamespace);
        }
        return this.currentNSState != null ? (ACC)this.currentNSState.get(this.currentKey) : null;
    }

    public void add(T value) throws IOException {
        if (this.currentKey == null) {
            throw new RuntimeException("No key available.");
        }
        if (this.currentNSState == null) {
            this.currentNSState = new HashMap();
            this.state.put(this.currentNamespace, this.currentNSState);
        }
        Object currentValue = this.currentNSState.get(this.currentKey);
        try {
            if (currentValue == null) {
                this.currentNSState.put(this.currentKey, this.foldFunction.fold(((FoldingStateDescriptor)this.stateDesc).getDefaultValue(), value));
            } else {
                this.currentNSState.put(this.currentKey, this.foldFunction.fold(currentValue, value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add value to folding state.", e);
        }
    }

    @Override
    public KvStateSnapshot<K, N, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>, MemoryStateBackend> createHeapSnapshot(byte[] bytes) {
        return new Snapshot(this.getKeySerializer(), this.getNamespaceSerializer(), this.stateSerializer, (FoldingStateDescriptor)this.stateDesc, bytes);
    }

    public static class Snapshot<K, N, T, ACC>
    extends AbstractMemStateSnapshot<K, N, ACC, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>> {
        private static final long serialVersionUID = 1L;

        public Snapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<ACC> stateSerializer, FoldingStateDescriptor<T, ACC> stateDescs, byte[] data) {
            super(keySerializer, namespaceSerializer, stateSerializer, stateDescs, data);
        }

        @Override
        public KvState<K, N, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>, MemoryStateBackend> createMemState(HashMap<N, Map<K, ACC>> stateMap) {
            return new MemFoldingState(this.keySerializer, this.namespaceSerializer, (FoldingStateDescriptor)this.stateDesc, stateMap);
        }
    }
}

