/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import akka.dispatch.Futures;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.ExecutionGraphRestarter;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class FixedDelayRestartStrategy
implements RestartStrategy {
    private final int maxNumberRestartAttempts;
    private final long delayBetweenRestartAttempts;
    private int currentRestartAttempt;

    public FixedDelayRestartStrategy(int maxNumberRestartAttempts, long delayBetweenRestartAttempts) {
        Preconditions.checkArgument((maxNumberRestartAttempts >= 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts must be positive.");
        Preconditions.checkArgument((delayBetweenRestartAttempts >= 0L ? 1 : 0) != 0, (Object)"Delay between restart attempts must be positive");
        this.maxNumberRestartAttempts = maxNumberRestartAttempts;
        this.delayBetweenRestartAttempts = delayBetweenRestartAttempts;
        this.currentRestartAttempt = 0;
    }

    public int getCurrentRestartAttempt() {
        return this.currentRestartAttempt;
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt < this.maxNumberRestartAttempts;
    }

    @Override
    public void restart(ExecutionGraph executionGraph) {
        ++this.currentRestartAttempt;
        Futures.future(ExecutionGraphRestarter.restartWithDelay(executionGraph, this.delayBetweenRestartAttempts), (ExecutionContext)executionGraph.getExecutionContext());
    }

    public static FixedDelayRestartStrategyFactory createFactory(Configuration configuration) throws Exception {
        long delay;
        int maxAttempts = configuration.getInteger("restart-strategy.fixed-delay.attempts", 1);
        String timeoutString = configuration.getString("akka.watch.heartbeat.interval", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
        String delayString = configuration.getString("restart-strategy.fixed-delay.delay", timeoutString);
        try {
            delay = Duration.apply((String)delayString).toMillis();
        }
        catch (NumberFormatException nfe) {
            if (delayString.equals(timeoutString)) {
                throw new Exception("Invalid config value for akka.watch.heartbeat.pause: " + timeoutString + ". Value must be a valid duration (such as '10 s' or '1 min')");
            }
            throw new Exception("Invalid config value for restart-strategy.fixed-delay.delay: " + delayString + ". Value must be a valid duration (such as '100 milli' or '10 s')");
        }
        return new FixedDelayRestartStrategyFactory(maxAttempts, delay);
    }

    public String toString() {
        return "FixedDelayRestartStrategy(maxNumberRestartAttempts=" + this.maxNumberRestartAttempts + ", delayBetweenRestartAttempts=" + this.delayBetweenRestartAttempts + ')';
    }

    public static class FixedDelayRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = 6642934067762271950L;
        private final int maxAttempts;
        private final long delay;

        public FixedDelayRestartStrategyFactory(int maxAttempts, long delay) {
            this.maxAttempts = maxAttempts;
            this.delay = delay;
        }

        @Override
        public RestartStrategy createRestartStrategy() {
            return new FixedDelayRestartStrategy(this.maxAttempts, this.delay);
        }
    }
}

