/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateBackend;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;

public abstract class AbstractStateBackend
implements Serializable {
    private static final long serialVersionUID = 4620413814639220247L;
    protected transient TypeSerializer<?> keySerializer;
    protected transient ClassLoader userCodeClassLoader;
    protected transient Object currentKey;
    private transient KvState<?, ?, ?, ?, ?>[] keyValueStates;
    private transient HashMap<String, KvState<?, ?, ?, ?, ?>> keyValueStatesByName;
    private transient String lastName;
    private transient KvState lastState;

    public void initializeForJob(Environment env, String operatorIdentifier, TypeSerializer<?> keySerializer) throws Exception {
        this.userCodeClassLoader = env.getUserClassLoader();
        this.keySerializer = keySerializer;
    }

    public abstract void disposeAllStateForCurrentJob() throws Exception;

    public abstract void close() throws Exception;

    public void dispose() {
        if (this.keyValueStates != null) {
            for (KvState<?, ?, ?, ?, ?> state : this.keyValueStates) {
                state.dispose();
            }
        }
    }

    protected abstract <N, T> ValueState<T> createValueState(TypeSerializer<N> var1, ValueStateDescriptor<T> var2) throws Exception;

    protected abstract <N, T> ListState<T> createListState(TypeSerializer<N> var1, ListStateDescriptor<T> var2) throws Exception;

    protected abstract <N, T> ReducingState<T> createReducingState(TypeSerializer<N> var1, ReducingStateDescriptor<T> var2) throws Exception;

    protected abstract <N, T, ACC> FoldingState<T, ACC> createFoldingState(TypeSerializer<N> var1, FoldingStateDescriptor<T, ACC> var2) throws Exception;

    public void setCurrentKey(Object currentKey) {
        this.currentKey = currentKey;
        if (this.keyValueStates != null) {
            for (KvState<?, ?, ?, ?, ?> kv : this.keyValueStates) {
                kv.setCurrentKey(currentKey);
            }
        }
    }

    public Object getCurrentKey() {
        return this.currentKey;
    }

    public <N, S extends State> S getPartitionedState(N namespace, final TypeSerializer<N> namespaceSerializer, StateDescriptor<S, ?> stateDescriptor) throws Exception {
        if (this.keySerializer == null) {
            throw new Exception("State key serializer has not been configured in the config. This operation cannot use partitioned state.");
        }
        if (!stateDescriptor.isSerializerInitialized()) {
            stateDescriptor.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        if (this.keyValueStatesByName == null) {
            this.keyValueStatesByName = new HashMap();
        }
        if (this.lastName != null && this.lastName.equals(stateDescriptor.getName())) {
            this.lastState.setCurrentNamespace(namespace);
            return (S)((State)this.lastState);
        }
        KvState<?, ?, ?, ?, ?> previous = this.keyValueStatesByName.get(stateDescriptor.getName());
        if (previous != null) {
            this.lastState = previous;
            this.lastState.setCurrentNamespace(namespace);
            this.lastName = stateDescriptor.getName();
            return (S)((State)previous);
        }
        State kvstate = stateDescriptor.bind(new StateBackend(){

            public <T> ValueState<T> createValueState(ValueStateDescriptor<T> stateDesc) throws Exception {
                return AbstractStateBackend.this.createValueState(namespaceSerializer, stateDesc);
            }

            public <T> ListState<T> createListState(ListStateDescriptor<T> stateDesc) throws Exception {
                return AbstractStateBackend.this.createListState(namespaceSerializer, stateDesc);
            }

            public <T> ReducingState<T> createReducingState(ReducingStateDescriptor<T> stateDesc) throws Exception {
                return AbstractStateBackend.this.createReducingState(namespaceSerializer, stateDesc);
            }

            public <T, ACC> FoldingState<T, ACC> createFoldingState(FoldingStateDescriptor<T, ACC> stateDesc) throws Exception {
                return AbstractStateBackend.this.createFoldingState(namespaceSerializer, stateDesc);
            }
        });
        this.keyValueStatesByName.put(stateDescriptor.getName(), (KvState)kvstate);
        this.keyValueStates = this.keyValueStatesByName.values().toArray(new KvState[this.keyValueStatesByName.size()]);
        this.lastName = stateDescriptor.getName();
        this.lastState = (KvState)kvstate;
        ((KvState)kvstate).setCurrentKey(this.currentKey);
        ((KvState)kvstate).setCurrentNamespace(namespace);
        return (S)kvstate;
    }

    public HashMap<String, KvStateSnapshot<?, ?, ?, ?, ?>> snapshotPartitionedState(long checkpointId, long timestamp) throws Exception {
        if (this.keyValueStates != null) {
            HashMap snapshots = new HashMap(this.keyValueStatesByName.size());
            for (Map.Entry<String, KvState<?, ?, ?, ?, ?>> entry : this.keyValueStatesByName.entrySet()) {
                KvStateSnapshot<?, ?, ?, ?, ?> snapshot = entry.getValue().snapshot(checkpointId, timestamp);
                snapshots.put(entry.getKey(), snapshot);
            }
            return snapshots;
        }
        return null;
    }

    public void notifyOfCompletedCheckpoint(long checkpointId) throws Exception {
        if (this.keyValueStates != null) {
            for (KvState<?, ?, ?, ?, ?> kvstate : this.keyValueStates) {
                if (!(kvstate instanceof CheckpointListener)) continue;
                ((CheckpointListener)((Object)kvstate)).notifyCheckpointComplete(checkpointId);
            }
        }
    }

    public final void injectKeyValueStateSnapshots(HashMap<String, KvStateSnapshot> keyValueStateSnapshots, long recoveryTimestamp) throws Exception {
        if (keyValueStateSnapshots != null) {
            if (this.keyValueStatesByName == null) {
                this.keyValueStatesByName = new HashMap();
            }
            for (Map.Entry<String, KvStateSnapshot> state : keyValueStateSnapshots.entrySet()) {
                KvState kvState = state.getValue().restoreState(this, this.keySerializer, this.userCodeClassLoader, recoveryTimestamp);
                this.keyValueStatesByName.put(state.getKey(), kvState);
            }
            this.keyValueStates = this.keyValueStatesByName.values().toArray(new KvState[this.keyValueStatesByName.size()]);
        }
    }

    public abstract CheckpointStateOutputStream createCheckpointStateOutputStream(long var1, long var3) throws Exception;

    public CheckpointStateOutputView createCheckpointStateOutputView(long checkpointID, long timestamp) throws Exception {
        return new CheckpointStateOutputView(this.createCheckpointStateOutputStream(checkpointID, timestamp));
    }

    public abstract <S extends Serializable> StateHandle<S> checkpointStateSerializable(S var1, long var2, long var4) throws Exception;

    private static final class DataInputViewHandle
    implements StateHandle<DataInputView> {
        private static final long serialVersionUID = 2891559813513532079L;
        private final StreamStateHandle stream;

        private DataInputViewHandle(StreamStateHandle stream) {
            this.stream = stream;
        }

        @Override
        public DataInputView getState(ClassLoader userCodeClassLoader) throws Exception {
            return new DataInputViewStreamWrapper((InputStream)this.stream.getState(userCodeClassLoader));
        }

        @Override
        public void discardState() throws Exception {
            this.stream.discardState();
        }

        @Override
        public long getStateSize() throws Exception {
            return this.stream.getStateSize();
        }
    }

    public static final class CheckpointStateOutputView
    extends DataOutputViewStreamWrapper {
        private final CheckpointStateOutputStream out;

        public CheckpointStateOutputView(CheckpointStateOutputStream out) {
            super((OutputStream)out);
            this.out = out;
        }

        public StateHandle<DataInputView> closeAndGetHandle() throws IOException {
            return new DataInputViewHandle(this.out.closeAndGetHandle());
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static abstract class CheckpointStateOutputStream
    extends OutputStream {
        public abstract StreamStateHandle closeAndGetHandle() throws IOException;
    }
}

