/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.KvState;

public abstract class AbstractHeapState<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>, Backend extends AbstractStateBackend>
implements KvState<K, N, S, SD, Backend>,
State {
    protected final HashMap<N, Map<K, SV>> state;
    protected final TypeSerializer<SV> stateSerializer;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    protected final SD stateDesc;
    protected K currentKey;
    protected N currentNamespace = null;
    protected Map<K, SV> currentNSState;

    protected AbstractHeapState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc) {
        this(keySerializer, namespaceSerializer, stateSerializer, stateDesc, new HashMap());
    }

    protected AbstractHeapState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc, HashMap<N, Map<K, SV>> state) {
        this.state = Objects.requireNonNull(state);
        this.keySerializer = Objects.requireNonNull(keySerializer);
        this.namespaceSerializer = Objects.requireNonNull(namespaceSerializer);
        this.stateSerializer = stateSerializer;
        this.stateDesc = stateDesc;
    }

    public final void clear() {
        if (this.currentNSState != null) {
            this.currentNSState.remove(this.currentKey);
            if (this.currentNSState.isEmpty()) {
                this.state.remove(this.currentNamespace);
                this.currentNSState = null;
            }
        }
    }

    @Override
    public final void setCurrentKey(K currentKey) {
        this.currentKey = currentKey;
    }

    @Override
    public final void setCurrentNamespace(N namespace) {
        if (namespace != null && namespace.equals(this.currentNamespace)) {
            return;
        }
        this.currentNamespace = namespace;
        this.currentNSState = this.state.get(this.currentNamespace);
    }

    protected final int size() {
        int size = 0;
        for (Map<K, SV> namespace : this.state.values()) {
            size += namespace.size();
        }
        return size;
    }

    @Override
    public void dispose() {
        this.state.clear();
    }

    public final TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public final TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }
}

