/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.broadcast.BroadcastVariableMaterialization;
import org.apache.flink.runtime.broadcast.InitializationTypeConflictException;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class DistributedRuntimeUDFContext
extends AbstractRuntimeUDFContext {
    private final HashMap<String, BroadcastVariableMaterialization<?, ?>> broadcastVars = new HashMap();

    public DistributedRuntimeUDFContext(TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators) {
        super(taskInfo, userCodeClassLoader, executionConfig, accumulators, cpTasks);
    }

    public <T> List<T> getBroadcastVariable(String name) {
        Preconditions.checkNotNull(name);
        BroadcastVariableMaterialization<?, ?> variable = this.broadcastVars.get(name);
        if (variable != null) {
            try {
                return variable.getVariable();
            }
            catch (InitializationTypeConflictException e) {
                throw new RuntimeException("The broadcast variable '" + name + "' has been initialized by a prior call to a " + e.getType());
            }
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name + "' has not been set.");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        if (name == null) {
            throw new NullPointerException("Thw broadcast variable name must not be null.");
        }
        if (initializer == null) {
            throw new NullPointerException("Thw broadcast variable initializer must not be null.");
        }
        BroadcastVariableMaterialization<?, ?> variable = this.broadcastVars.get(name);
        if (variable != null) {
            return (C)variable.getVariable(initializer);
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name + "' has not been set.");
    }

    public void setBroadcastVariable(String name, BroadcastVariableMaterialization<?, ?> value) {
        this.broadcastVars.put(name, value);
    }

    public void clearBroadcastVariable(String name) {
        this.broadcastVars.remove(name);
    }

    public void clearAllBroadcastVariables() {
        this.broadcastVars.clear();
    }
}

