/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import org.apache.flink.runtime.operators.sort.HeapSort;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.runtime.operators.sort.IndexedSorter;

public final class QuickSort
implements IndexedSorter {
    private static final IndexedSorter alt = new HeapSort();

    private static void fix(IndexedSortable s, int p, int r) {
        if (s.compare(p, r) > 0) {
            s.swap(p, r);
        }
    }

    protected static int getMaxDepth(int x) {
        if (x <= 0) {
            throw new IllegalArgumentException("Undefined for " + x);
        }
        return 32 - Integer.numberOfLeadingZeros(x - 1) << 2;
    }

    @Override
    public void sort(IndexedSortable s, int p, int r) {
        QuickSort.sortInternal(s, p, r, QuickSort.getMaxDepth(r - p));
    }

    @Override
    public void sort(IndexedSortable s) {
        this.sort(s, 0, s.size());
    }

    private static void sortInternal(IndexedSortable s, int p, int r, int depth) {
        while (true) {
            int j;
            int i;
            if (r - p < 13) {
                for (i = p; i < r; ++i) {
                    for (j = i; j > p && s.compare(j - 1, j) > 0; --j) {
                        s.swap(j, j - 1);
                    }
                }
                return;
            }
            if (--depth < 0) {
                alt.sort(s, p, r);
                return;
            }
            QuickSort.fix(s, p + r >>> 1, p);
            QuickSort.fix(s, p + r >>> 1, r - 1);
            QuickSort.fix(s, p, r - 1);
            i = p;
            j = r;
            int ll = p;
            int rr = r;
            while (true) {
                int cr;
                if (++i < j && (cr = s.compare(i, p)) <= 0) {
                    if (0 != cr || ++ll == i) continue;
                    s.swap(ll, i);
                    continue;
                }
                while (--j > i && (cr = s.compare(p, j)) <= 0) {
                    if (0 != cr || --rr == j) continue;
                    s.swap(rr, j);
                }
                if (i >= j) break;
                s.swap(i, j);
            }
            j = i;
            while (ll >= p) {
                s.swap(ll--, --i);
            }
            while (rr < r) {
                s.swap(rr++, j++);
            }
            assert (i != j);
            if (i - p < r - j) {
                QuickSort.sortInternal(s, p, i, depth);
                p = j;
                continue;
            }
            QuickSort.sortInternal(s, j, r, depth);
            r = i;
        }
    }
}

