/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.JoinDriver;
import org.apache.flink.runtime.operators.ResettableDriver;
import org.apache.flink.runtime.operators.hash.NonReusingBuildFirstReOpenableHashJoinIterator;
import org.apache.flink.runtime.operators.hash.NonReusingBuildSecondReOpenableHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildFirstReOpenableHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondReOpenableHashJoinIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public abstract class AbstractCachedBuildSideJoinDriver<IT1, IT2, OT>
extends JoinDriver<IT1, IT2, OT>
implements ResettableDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    private volatile JoinTaskIterator<IT1, IT2, OT> matchIterator;
    private final int buildSideIndex;
    private final int probeSideIndex;
    private boolean objectReuseEnabled = false;

    protected AbstractCachedBuildSideJoinDriver(int buildSideIndex, int probeSideIndex) {
        this.buildSideIndex = buildSideIndex;
        this.probeSideIndex = probeSideIndex;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return inputNum == this.buildSideIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator comparator1 = this.taskContext.getDriverComparator(0);
        TypeComparator comparator2 = this.taskContext.getDriverComparator(1);
        MutableObjectIterator input1 = this.taskContext.getInput(0);
        MutableObjectIterator input2 = this.taskContext.getInput(1);
        TypePairComparatorFactory pairComparatorFactory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        double availableMemory = config.getRelativeMemoryDriver();
        boolean hashJoinUseBitMaps = this.taskContext.getTaskManagerInfo().getConfiguration().getBoolean("taskmanager.runtime.hashjoin-bloom-filters", false);
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (this.objectReuseEnabled) {
            if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
                this.matchIterator = new ReusingBuildFirstReOpenableHashJoinIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory, false, false, hashJoinUseBitMaps);
            } else {
                if (this.buildSideIndex != 1 || this.probeSideIndex != 0) throw new Exception("Error: Inconsistent setup for repeatable hash join driver.");
                this.matchIterator = new ReusingBuildSecondReOpenableHashJoinIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory, false, false, hashJoinUseBitMaps);
            }
        } else if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
            this.matchIterator = new NonReusingBuildFirstReOpenableHashJoinIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory, false, false, hashJoinUseBitMaps);
        } else {
            if (this.buildSideIndex != 1 || this.probeSideIndex != 0) throw new Exception("Error: Inconsistent setup for repeatable hash join driver.");
            this.matchIterator = new NonReusingBuildSecondReOpenableHashJoinIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory, false, false, hashJoinUseBitMaps);
        }
        this.matchIterator.open();
    }

    @Override
    public void prepare() throws Exception {
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction matchStub = (FlatJoinFunction)this.taskContext.getStub();
        Collector collector = this.taskContext.getOutputCollector();
        while (this.running && this.matchIterator != null && this.matchIterator.callWithNextKey(matchStub, collector)) {
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public void reset() throws Exception {
        MutableObjectIterator input1 = this.taskContext.getInput(0);
        MutableObjectIterator input2 = this.taskContext.getInput(1);
        if (this.objectReuseEnabled) {
            if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
                ReusingBuildFirstReOpenableHashJoinIterator matchIterator = (ReusingBuildFirstReOpenableHashJoinIterator)this.matchIterator;
                matchIterator.reopenProbe(input2);
            } else {
                ReusingBuildSecondReOpenableHashJoinIterator matchIterator = (ReusingBuildSecondReOpenableHashJoinIterator)this.matchIterator;
                matchIterator.reopenProbe(input1);
            }
        } else if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
            NonReusingBuildFirstReOpenableHashJoinIterator matchIterator = (NonReusingBuildFirstReOpenableHashJoinIterator)this.matchIterator;
            matchIterator.reopenProbe(input2);
        } else {
            NonReusingBuildSecondReOpenableHashJoinIterator matchIterator = (NonReusingBuildSecondReOpenableHashJoinIterator)this.matchIterator;
            matchIterator.reopenProbe(input1);
        }
    }

    @Override
    public void teardown() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.close();
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.abort();
        }
    }
}

