/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class StandaloneLeaderElectionService
implements LeaderElectionService {
    private LeaderContender contender = null;

    @Override
    public void start(LeaderContender newContender) throws Exception {
        if (this.contender != null) {
            throw new IllegalArgumentException("Leader election service cannot be started multiple times.");
        }
        this.contender = Preconditions.checkNotNull(newContender);
        this.contender.grantLeadership(null);
    }

    @Override
    public void stop() {
        if (this.contender != null) {
            this.contender.revokeLeadership();
            this.contender = null;
        }
    }

    @Override
    public void confirmLeaderSessionID(UUID leaderSessionID) {
    }

    @Override
    public boolean hasLeadership() {
        return true;
    }
}

