/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.AbstractID;

public class CoLocationGroup
implements Serializable {
    private static final long serialVersionUID = -2605819490401895297L;
    private final AbstractID id = new AbstractID();
    private final List<JobVertex> vertices = new ArrayList<JobVertex>();
    private transient ArrayList<CoLocationConstraint> constraints;

    public CoLocationGroup() {
    }

    public CoLocationGroup(JobVertex ... vertices) {
        for (JobVertex v : vertices) {
            this.vertices.add(v);
        }
    }

    public void addVertex(JobVertex vertex) {
        Preconditions.checkNotNull(vertex);
        this.vertices.add(vertex);
    }

    public void mergeInto(CoLocationGroup other) {
        Preconditions.checkNotNull(other);
        for (JobVertex v : this.vertices) {
            v.updateCoLocationGroup(other);
        }
        other.vertices.addAll(this.vertices);
        this.vertices.clear();
    }

    public CoLocationConstraint getLocationConstraint(int subtask) {
        this.ensureConstraints(subtask + 1);
        return this.constraints.get(subtask);
    }

    private void ensureConstraints(int num) {
        if (this.constraints == null) {
            this.constraints = new ArrayList(num);
        } else {
            this.constraints.ensureCapacity(num);
        }
        if (num > this.constraints.size()) {
            this.constraints.ensureCapacity(num);
            for (int i = this.constraints.size(); i < num; ++i) {
                this.constraints.add(new CoLocationConstraint(this));
            }
        }
    }

    public AbstractID getId() {
        return this.id;
    }

    public void resetConstraints() {
        for (CoLocationConstraint c : this.constraints) {
            if (!c.isAssignedAndAlive()) continue;
            throw new IllegalStateException("Cannot reset co-location group: some constraints still have live tasks");
        }
        this.constraints.clear();
    }
}

