/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.JobSnapshottingSettings;

public class JobGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<JobVertexID, JobVertex> taskVertices = new LinkedHashMap<JobVertexID, JobVertex>();
    private final Configuration jobConfiguration = new Configuration();
    private final List<Path> userJars = new ArrayList<Path>();
    private final List<BlobKey> userJarBlobKeys = new ArrayList<BlobKey>();
    private final JobID jobID;
    private final String jobName;
    private RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration;
    private long sessionTimeout = 0L;
    private boolean allowQueuedScheduling;
    private ScheduleMode scheduleMode = ScheduleMode.FROM_SOURCES;
    private JobSnapshottingSettings snapshotSettings;
    private List<URL> classpaths = Collections.emptyList();

    public JobGraph() {
        this((String)null);
    }

    public JobGraph(String jobName) {
        this(null, jobName);
    }

    public JobGraph(JobID jobId, String jobName) {
        this.jobID = jobId == null ? new JobID() : jobId;
        this.jobName = jobName == null ? "(unnamed job)" : jobName;
    }

    public JobGraph(JobVertex ... vertices) {
        this((String)null, vertices);
    }

    public JobGraph(String jobName, JobVertex ... vertices) {
        this(null, jobName, vertices);
    }

    public JobGraph(JobID jobId, String jobName, JobVertex ... vertices) {
        this(jobId, jobName);
        for (JobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setRestartStrategyConfiguration(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.restartStrategyConfiguration = restartStrategyConfiguration;
    }

    public RestartStrategies.RestartStrategyConfiguration getRestartStrategyConfiguration() {
        return this.restartStrategyConfiguration;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setAllowQueuedScheduling(boolean allowQueuedScheduling) {
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    public boolean getAllowQueuedScheduling() {
        return this.allowQueuedScheduling;
    }

    public void setScheduleMode(ScheduleMode scheduleMode) {
        this.scheduleMode = scheduleMode;
    }

    public ScheduleMode getScheduleMode() {
        return this.scheduleMode;
    }

    public void addVertex(JobVertex vertex) {
        JobVertexID id = vertex.getID();
        JobVertex previous = this.taskVertices.put(id, vertex);
        if (previous != null) {
            this.taskVertices.put(id, previous);
            throw new IllegalArgumentException("The JobGraph already contains a vertex with that id.");
        }
    }

    public Iterable<JobVertex> getVertices() {
        return this.taskVertices.values();
    }

    public JobVertex[] getVerticesAsArray() {
        return this.taskVertices.values().toArray(new JobVertex[this.taskVertices.size()]);
    }

    public int getNumberOfVertices() {
        return this.taskVertices.size();
    }

    public void setSnapshotSettings(JobSnapshottingSettings settings) {
        this.snapshotSettings = settings;
    }

    public JobSnapshottingSettings getSnapshotSettings() {
        return this.snapshotSettings;
    }

    public JobVertex findVertexByID(JobVertexID id) {
        return this.taskVertices.get((Object)id);
    }

    public void setClasspaths(List<URL> paths) {
        this.classpaths = paths;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public void setSavepointPath(String savepointPath) {
        if (savepointPath != null) {
            if (this.snapshotSettings == null) {
                throw new IllegalStateException("Checkpointing disabled");
            }
            this.snapshotSettings.setSavepointPath(savepointPath);
        }
    }

    public List<JobVertex> getVerticesSortedTopologicallyFromSources() throws InvalidProgramException {
        if (this.taskVertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JobVertex> sorted = new ArrayList<JobVertex>(this.taskVertices.size());
        LinkedHashSet<JobVertex> remaining = new LinkedHashSet<JobVertex>(this.taskVertices.values());
        Iterator iter = remaining.iterator();
        while (iter.hasNext()) {
            JobVertex vertex = (JobVertex)iter.next();
            if (!vertex.hasNoConnectedInputs()) continue;
            sorted.add(vertex);
            iter.remove();
        }
        int startNodePos = 0;
        while (!remaining.isEmpty()) {
            if (startNodePos >= sorted.size()) {
                throw new InvalidProgramException("The job graph is cyclic.");
            }
            JobVertex current = (JobVertex)sorted.get(startNodePos++);
            this.addNodesThatHaveNoNewPredecessors(current, sorted, remaining);
        }
        return sorted;
    }

    private void addNodesThatHaveNoNewPredecessors(JobVertex start, List<JobVertex> target, Set<JobVertex> remaining) {
        for (IntermediateDataSet dataSet : start.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                JobVertex v = edge.getTarget();
                if (!remaining.contains(v)) continue;
                boolean hasNewPredecessors = false;
                for (JobEdge e : v.getInputs()) {
                    IntermediateDataSet source;
                    if (e == edge || !remaining.contains((source = e.getSource()).getProducer())) continue;
                    hasNewPredecessors = true;
                    break;
                }
                if (hasNewPredecessors) continue;
                target.add(v);
                remaining.remove(v);
                this.addNodesThatHaveNoNewPredecessors(v, target, remaining);
            }
        }
    }

    public void addJar(Path jar) {
        if (jar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public void addBlob(BlobKey key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJarBlobKeys.contains(key)) {
            this.userJarBlobKeys.add(key);
        }
    }

    public boolean hasUsercodeJarFiles() {
        return this.userJars.size() > 0;
    }

    public List<BlobKey> getUserJarBlobKeys() {
        return this.userJarBlobKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadRequiredJarFiles(InetSocketAddress serverAddress) throws IOException {
        if (this.userJars.isEmpty()) {
            return;
        }
        try (BlobClient bc = null;){
            bc = new BlobClient(serverAddress);
            for (Path jar : this.userJars) {
                FileSystem fs = jar.getFileSystem();
                FSDataInputStream is = null;
                try {
                    is = fs.open(jar);
                    BlobKey key = bc.put((InputStream)is);
                    this.userJarBlobKeys.add(key);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    public int getMaximumParallelism() {
        int maxParallelism = -1;
        for (JobVertex vertex : this.taskVertices.values()) {
            maxParallelism = Math.max(vertex.getParallelism(), maxParallelism);
        }
        return maxParallelism;
    }

    public String toString() {
        return "JobGraph(jobId: " + this.jobID + ")";
    }
}

