/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import akka.dispatch.Futures;
import java.util.concurrent.Callable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class FixedDelayRestartStrategy
implements RestartStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FixedDelayRestartStrategy.class);
    private final int maxNumberRestartAttempts;
    private final long delayBetweenRestartAttempts;
    private int currentRestartAttempt;

    public FixedDelayRestartStrategy(int maxNumberRestartAttempts, long delayBetweenRestartAttempts) {
        Preconditions.checkArgument(maxNumberRestartAttempts >= 0, "Maximum number of restart attempts must be positive.");
        Preconditions.checkArgument(delayBetweenRestartAttempts >= 0L, "Delay between restart attempts must be positive");
        this.maxNumberRestartAttempts = maxNumberRestartAttempts;
        this.delayBetweenRestartAttempts = delayBetweenRestartAttempts;
        this.currentRestartAttempt = 0;
    }

    public int getCurrentRestartAttempt() {
        return this.currentRestartAttempt;
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt < this.maxNumberRestartAttempts;
    }

    @Override
    public void restart(final ExecutionGraph executionGraph) {
        ++this.currentRestartAttempt;
        Futures.future((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    LOG.info("Delaying retry of job execution for {} ms ...", (Object)FixedDelayRestartStrategy.this.delayBetweenRestartAttempts);
                    Thread.sleep(FixedDelayRestartStrategy.this.delayBetweenRestartAttempts);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                executionGraph.restart();
                return null;
            }
        }, (ExecutionContext)executionGraph.getExecutionContext());
    }

    public static FixedDelayRestartStrategy create(Configuration configuration) throws Exception {
        long delay;
        int maxAttempts = configuration.getInteger("restart-strategy.fixed-delay.attempts", 1);
        String timeoutString = configuration.getString("akka.watch.heartbeat.interval", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
        String delayString = configuration.getString("restart-strategy.fixed-delay.delay", timeoutString);
        try {
            delay = Duration.apply((String)delayString).toMillis();
        }
        catch (NumberFormatException nfe) {
            if (delayString.equals(timeoutString)) {
                throw new Exception("Invalid config value for akka.watch.heartbeat.pause: " + timeoutString + ". Value must be a valid duration (such as '10 s' or '1 min')");
            }
            throw new Exception("Invalid config value for execution-retries.delay: " + delayString + ". Value must be a valid duration (such as '100 milli' or '10 s')");
        }
        return new FixedDelayRestartStrategy(maxAttempts, delay);
    }

    public String toString() {
        return "FixedDelayRestartStrategy(maxNumberRestartAttempts=" + this.maxNumberRestartAttempts + ", delayBetweenRestartAttempts=" + this.delayBetweenRestartAttempts + ')';
    }
}

