/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class PartialInputChannelDeploymentDescriptor {
    private final IntermediateDataSetID resultId;
    private final ResultPartitionID partitionID;
    private final InstanceConnectionInfo partitionConnectionInfo;
    private final int partitionConnectionIndex;

    public PartialInputChannelDeploymentDescriptor(IntermediateDataSetID resultId, ResultPartitionID partitionID, InstanceConnectionInfo partitionConnectionInfo, int partitionConnectionIndex) {
        this.resultId = Preconditions.checkNotNull(resultId);
        this.partitionID = Preconditions.checkNotNull(partitionID);
        this.partitionConnectionInfo = Preconditions.checkNotNull(partitionConnectionInfo);
        this.partitionConnectionIndex = partitionConnectionIndex;
    }

    public InputChannelDeploymentDescriptor createInputChannelDeploymentDescriptor(Execution consumerExecution) {
        Preconditions.checkNotNull(consumerExecution, "Consumer execution null");
        InstanceConnectionInfo consumerConnectionInfo = consumerExecution.getAssignedResourceLocation();
        Preconditions.checkNotNull(consumerConnectionInfo, "Consumer connection info null");
        ResultPartitionLocation partitionLocation = consumerConnectionInfo.equals(this.partitionConnectionInfo) ? ResultPartitionLocation.createLocal() : ResultPartitionLocation.createRemote(new ConnectionID(this.partitionConnectionInfo, this.partitionConnectionIndex));
        return new InputChannelDeploymentDescriptor(this.partitionID, partitionLocation);
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public static PartialInputChannelDeploymentDescriptor fromEdge(IntermediateResultPartition partition, Execution producer) {
        ResultPartitionID partitionId = new ResultPartitionID(partition.getPartitionId(), producer.getAttemptId());
        IntermediateResult result = partition.getIntermediateResult();
        IntermediateDataSetID resultId = result.getId();
        InstanceConnectionInfo partitionConnectionInfo = producer.getAssignedResourceLocation();
        int partitionConnectionIndex = result.getConnectionIndex();
        return new PartialInputChannelDeploymentDescriptor(resultId, partitionId, partitionConnectionInfo, partitionConnectionIndex);
    }
}

