/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.FileSystemStateStore;
import org.apache.flink.runtime.checkpoint.HeapStateStore;
import org.apache.flink.runtime.checkpoint.SavepointStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointStoreFactory {
    public static final String SAVEPOINT_BACKEND_KEY = "savepoints.state.backend";
    public static final String SAVEPOINT_DIRECTORY_KEY = "savepoints.state.backend.fs.dir";
    public static final String DEFAULT_SAVEPOINT_BACKEND = "jobmanager";
    public static final Logger LOG = LoggerFactory.getLogger(SavepointStoreFactory.class);

    public static SavepointStore createFromConfig(Configuration config) throws Exception {
        String savepointBackend = config.getString(SAVEPOINT_BACKEND_KEY, DEFAULT_SAVEPOINT_BACKEND);
        if (savepointBackend == null) {
            LOG.info("No savepoint state backend configured. Using job manager savepoint state backend.");
            return SavepointStoreFactory.createJobManagerSavepointStore();
        }
        if (savepointBackend.equals(DEFAULT_SAVEPOINT_BACKEND)) {
            LOG.info("Using job manager savepoint state backend.");
            return SavepointStoreFactory.createJobManagerSavepointStore();
        }
        if (savepointBackend.equals("filesystem")) {
            String rootPath = config.getString(SAVEPOINT_DIRECTORY_KEY, null);
            if (rootPath == null) {
                throw new IllegalConfigurationException("Using filesystem as savepoint state backend, but did not specify directory. Please set the following configuration key: 'savepoints.state.backend.fs.dir' (e.g. savepoints.state.backend.fs.dir: hdfs:///flink/savepoints/). Falling back to job manager savepoint backend.");
            }
            LOG.info("Using filesystem savepoint backend (root path: {}).", (Object)rootPath);
            return SavepointStoreFactory.createFileSystemSavepointStore(rootPath);
        }
        throw new IllegalConfigurationException("Unexpected savepoint backend configuration '" + savepointBackend + "'. " + "Falling back to job manager savepoint state backend.");
    }

    private static SavepointStore createJobManagerSavepointStore() {
        return new SavepointStore(new HeapStateStore<CompletedCheckpoint>());
    }

    private static SavepointStore createFileSystemSavepointStore(String rootPath) throws IOException {
        return new SavepointStore(new FileSystemStateStore<CompletedCheckpoint>(rootPath, "savepoint-"));
    }
}

