/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.StateForTask;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.SerializedValue;

public class PendingCheckpoint {
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final List<StateForTask> collectedStates;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private int numAcknowledgedTasks;
    private boolean discarded;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, Map<ExecutionAttemptID, ExecutionVertex> verticesToConfirm) {
        if (jobId == null || verticesToConfirm == null) {
            throw new NullPointerException();
        }
        if (verticesToConfirm.size() == 0) {
            throw new IllegalArgumentException("Checkpoint needs at least one vertex that commits the checkpoint");
        }
        this.jobId = jobId;
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.notYetAcknowledgedTasks = verticesToConfirm;
        this.collectedStates = new ArrayList<StateForTask>(this.notYetAcknowledgedTasks.size());
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public boolean isFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.discarded;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public List<StateForTask> getCollectedStates() {
        return this.collectedStates;
    }

    public CompletedCheckpoint toCompletedCheckpoint() {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                throw new IllegalStateException("pending checkpoint is discarded");
            }
            if (this.notYetAcknowledgedTasks.isEmpty()) {
                CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), new ArrayList<StateForTask>(this.collectedStates));
                this.dispose(null, false);
                return completed;
            }
            throw new IllegalStateException("Cannot complete checkpoint while not all tasks are acknowledged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeTask(ExecutionAttemptID attemptID, SerializedValue<StateHandle<?>> state, long stateSize) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return false;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove((Object)attemptID);
            if (vertex != null) {
                if (state != null) {
                    this.collectedStates.add(new StateForTask(state, stateSize, vertex.getJobvertexId(), vertex.getParallelSubtaskIndex(), System.currentTimeMillis() - this.checkpointTimestamp));
                }
                ++this.numAcknowledgedTasks;
                return true;
            }
            return false;
        }
    }

    public void discard(ClassLoader userClassLoader) {
        this.dispose(userClassLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(ClassLoader userClassLoader, boolean releaseState) {
        Object object = this.lock;
        synchronized (object) {
            this.discarded = true;
            this.numAcknowledgedTasks = -1;
            if (releaseState) {
                for (StateForTask state : this.collectedStates) {
                    state.discard(userClassLoader);
                }
            }
            this.collectedStates.clear();
            this.notYetAcknowledgedTasks.clear();
        }
    }

    public String toString() {
        return String.format("PendingCheckpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }
}

