/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.util.IOUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.io.BaseEncoding;
import org.slf4j.Logger;

public class BlobUtils {
    private static final String HASHING_ALGORITHM = "SHA-1";
    static final String BLOB_FILE_PREFIX = "blob_";
    static final String JOB_DIR_PREFIX = "job_";
    static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    static File initStorageDirectory(String storageDirectory) {
        File baseDir = storageDirectory == null || storageDirectory.trim().isEmpty() ? new File(System.getProperty("java.io.tmpdir")) : new File(storageDirectory);
        int MAX_ATTEMPTS = 10;
        for (int attempt = 0; attempt < 10; ++attempt) {
            File storageDir = new File(baseDir, String.format("blobStore-%s", UUID.randomUUID().toString()));
            if (storageDir.exists() || !storageDir.mkdirs()) continue;
            return storageDir;
        }
        throw new RuntimeException("Could not create storage directory for BLOB store in '" + baseDir + "'.");
    }

    static File getIncomingDirectory(File storageDir) {
        File incomingDir = new File(storageDir, "incoming");
        if (!incomingDir.exists() && !incomingDir.mkdirs()) {
            throw new RuntimeException("Cannot create directory for incoming files " + incomingDir.getAbsolutePath());
        }
        return incomingDir;
    }

    private static File getCacheDirectory(File storageDir) {
        File cacheDirectory = new File(storageDir, "cache");
        if (!cacheDirectory.exists() && !cacheDirectory.mkdirs()) {
            throw new RuntimeException("Could not create cache directory '" + cacheDirectory.getAbsolutePath() + "'.");
        }
        return cacheDirectory;
    }

    static File getStorageLocation(File storageDir, BlobKey key) {
        return new File(BlobUtils.getCacheDirectory(storageDir), BLOB_FILE_PREFIX + key.toString());
    }

    static File getStorageLocation(File storageDir, JobID jobID, String key) {
        return new File(BlobUtils.getJobDirectory(storageDir, jobID), BLOB_FILE_PREFIX + BlobUtils.encodeKey(key));
    }

    private static File getJobDirectory(File storageDir, JobID jobID) {
        File jobDirectory = new File(storageDir, JOB_DIR_PREFIX + jobID.toString());
        if (!jobDirectory.exists() && !jobDirectory.mkdirs()) {
            throw new RuntimeException("Could not create jobId directory '" + jobDirectory.getAbsolutePath() + "'.");
        }
        return jobDirectory;
    }

    static String encodeKey(String key) {
        return BaseEncoding.base64().encode(key.getBytes(DEFAULT_CHARSET));
    }

    static void deleteJobDirectory(File storageDir, JobID jobID) throws IOException {
        File directory = BlobUtils.getJobDirectory(storageDir, jobID);
        FileUtils.deleteDirectory((File)directory);
    }

    static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(HASHING_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate the message digest algorithm SHA-1", e);
        }
    }

    static Thread addShutdownHook(final BlobService service, final Logger logger) {
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(logger);
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    service.shutdown();
                }
                catch (Throwable t) {
                    logger.error("Error during shutdown of blob service via JVM shutdown hook: " + t.getMessage(), t);
                }
            }
        });
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            return shutdownHook;
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (Throwable t) {
            logger.error("Cannot register shutdown hook that cleanly terminates the BLOB service.");
            return null;
        }
    }

    static void writeLength(int length, OutputStream outputStream) throws IOException {
        byte[] buf = new byte[]{(byte)(length & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 24 & 0xFF)};
        outputStream.write(buf, 0, 4);
    }

    static int readLength(InputStream inputStream) throws IOException {
        int bytesRead;
        int read;
        byte[] buf = new byte[4];
        for (bytesRead = 0; bytesRead < 4; bytesRead += read) {
            read = inputStream.read(buf, bytesRead, 4 - bytesRead);
            if (read >= 0) continue;
            throw new EOFException("Read an incomplete length");
        }
        bytesRead = buf[0] & 0xFF;
        bytesRead |= (buf[1] & 0xFF) << 8;
        bytesRead |= (buf[2] & 0xFF) << 16;
        return bytesRead |= (buf[3] & 0xFF) << 24;
    }

    static void readFully(InputStream inputStream, byte[] buf, int off, int len, String type) throws IOException {
        int read;
        for (int bytesRead = 0; bytesRead < len; bytesRead += read) {
            read = inputStream.read(buf, off + bytesRead, len - bytesRead);
            if (read >= 0) continue;
            throw new EOFException("Received an incomplete " + type);
        }
    }

    static void closeSilently(Socket socket, Logger LOG) {
        block3: {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable t) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Error while closing resource after BLOB transfer.", t);
                }
            }
        }
    }

    static String getRecoveryPath(String basePath, BlobKey blobKey) {
        return String.format("%s/cache/%s", basePath, BLOB_FILE_PREFIX + blobKey.toString());
    }

    static String getRecoveryPath(String basePath, JobID jobId, String key) {
        return String.format("%s/%s/%s", basePath, JOB_DIR_PREFIX + jobId.toString(), BLOB_FILE_PREFIX + BlobUtils.encodeKey(key));
    }

    static String getRecoveryPath(String basePath, JobID jobId) {
        return String.format("%s/%s", basePath, JOB_DIR_PREFIX + jobId.toString());
    }

    static void copyFromRecoveryPath(String recoveryPath, File localBlobFile) throws Exception {
        if (recoveryPath == null) {
            throw new IllegalStateException("Failed to determine recovery path.");
        }
        if (!localBlobFile.createNewFile()) {
            throw new IllegalStateException("Failed to create new local file to copy to");
        }
        URI uri = new URI(recoveryPath);
        Path path = new Path(recoveryPath);
        if (FileSystem.get((URI)uri).exists(path)) {
            try (FSDataInputStream is = FileSystem.get((URI)uri).open(path);){
                FileOutputStream fos = new FileOutputStream(localBlobFile);
                IOUtils.copyBytes((InputStream)is, fos);
            }
        } else {
            throw new IOException("Cannot find required BLOB at '" + recoveryPath + "' for recovery.");
        }
    }

    private BlobUtils() {
        throw new RuntimeException();
    }
}

