/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.FieldSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class FieldAccessor<T, F>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected TypeInformation fieldType;

    public TypeInformation<F> getFieldType() {
        return this.fieldType;
    }

    public abstract F get(T var1);

    public abstract T set(T var1, F var2);

    static final class PojoFieldAccessor<T, R, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private transient Field field;
        private final FieldAccessor<R, F> innerAccessor;

        PojoFieldAccessor(Field field, FieldAccessor<R, F> innerAccessor) {
            Preconditions.checkNotNull((Object)field, (String)"field must not be null.");
            Preconditions.checkNotNull(innerAccessor, (String)"innerAccessor must not be null.");
            this.field = field;
            this.innerAccessor = innerAccessor;
            this.fieldType = innerAccessor.fieldType;
        }

        @Override
        public F get(T pojo) {
            try {
                Object inner = this.field.get(pojo);
                return this.innerAccessor.get(inner);
            }
            catch (IllegalAccessException iaex) {
                throw new RuntimeException("This should not happen since we call setAccesssible(true) in readObject. fields: " + String.valueOf(this.field) + " obj: " + String.valueOf(pojo));
            }
        }

        @Override
        public T set(T pojo, F valueToSet) {
            try {
                Object inner = this.field.get(pojo);
                this.field.set(pojo, this.innerAccessor.set(inner, valueToSet));
                return pojo;
            }
            catch (IllegalAccessException iaex) {
                throw new RuntimeException("This should not happen since we call setAccesssible(true) in readObject. fields: " + String.valueOf(this.field) + " obj: " + String.valueOf(pojo));
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
            out.defaultWriteObject();
            FieldSerializer.serializeField((Field)this.field, (ObjectOutputStream)out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.field = FieldSerializer.deserializeField((ObjectInputStream)in);
        }
    }

    static final class RecursiveTupleFieldAccessor<T extends Tuple, R, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final FieldAccessor<R, F> innerAccessor;

        RecursiveTupleFieldAccessor(int pos, FieldAccessor<R, F> innerAccessor, TypeInformation<T> typeInfo) {
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            Preconditions.checkNotNull(innerAccessor, (String)"innerAccessor must not be null.");
            int arity = ((TupleTypeInfo)typeInfo).getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(pos).toString() + ". field on \"" + typeInfo.toString() + "\", which is an invalid index.");
            }
            this.pos = pos;
            this.innerAccessor = innerAccessor;
            this.fieldType = innerAccessor.fieldType;
        }

        @Override
        public F get(T record) {
            Object inner = record.getField(this.pos);
            return this.innerAccessor.get(inner);
        }

        @Override
        public T set(T record, F fieldValue) {
            Object inner = record.getField(this.pos);
            record.setField(this.innerAccessor.set(inner, fieldValue), this.pos);
            return record;
        }
    }

    static final class SimpleTupleFieldAccessor<T extends Tuple, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;

        SimpleTupleFieldAccessor(int pos, TypeInformation<T> typeInfo) {
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            int arity = ((TupleTypeInfo)typeInfo).getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(pos).toString() + ". field on \"" + typeInfo.toString() + "\", which is an invalid index.");
            }
            this.pos = pos;
            this.fieldType = ((TupleTypeInfo)typeInfo).getTypeAt(pos);
        }

        @Override
        public F get(T record) {
            return (F)record.getField(this.pos);
        }

        @Override
        public T set(T record, F fieldValue) {
            record.setField(fieldValue, this.pos);
            return record;
        }
    }

    static final class ArrayFieldAccessor<T, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;

        public ArrayFieldAccessor(int pos, TypeInformation typeInfo) {
            if (pos < 0) {
                throw new CompositeType.InvalidFieldReferenceException("The " + Integer.valueOf(pos).toString() + ". field selected on an array, which is an invalid index.");
            }
            Preconditions.checkNotNull((Object)typeInfo, (String)"typeInfo must not be null.");
            this.pos = pos;
            this.fieldType = BasicTypeInfo.getInfoFor(typeInfo.getTypeClass().getComponentType());
        }

        @Override
        public F get(T record) {
            return (F)Array.get(record, this.pos);
        }

        @Override
        public T set(T record, F fieldValue) {
            Array.set(record, this.pos, fieldValue);
            return record;
        }
    }

    static final class SimpleFieldAccessor<T>
    extends FieldAccessor<T, T> {
        private static final long serialVersionUID = 1L;

        public SimpleFieldAccessor(TypeInformation<T> typeInfo) {
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            this.fieldType = typeInfo;
        }

        @Override
        public T get(T record) {
            return record;
        }

        @Override
        public T set(T record, T fieldValue) {
            return fieldValue;
        }
    }
}

