/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncCountTrigger;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncEventTimeTrigger;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncProcessingTimeTrigger;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncPurgingTrigger;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;

@Internal
public interface AsyncTriggerConverter {
    @Nonnull
    default public Object convertToAsync() {
        return UserDefinedAsyncTrigger.of((Trigger)((Object)this));
    }

    public static <T, W extends Window> AsyncTrigger<T, W> convertToAsync(Trigger<T, W> trigger) {
        if (trigger instanceof CountTrigger) {
            return AsyncCountTrigger.of(((CountTrigger)trigger).getMaxCount());
        }
        if (trigger instanceof EventTimeTrigger) {
            return AsyncEventTimeTrigger.create();
        }
        if (trigger instanceof ProcessingTimeTrigger) {
            return AsyncProcessingTimeTrigger.create();
        }
        if (trigger instanceof PurgingTrigger) {
            return AsyncPurgingTrigger.of(AsyncTriggerConverter.convertToAsync(((PurgingTrigger)trigger).getNestedTrigger()));
        }
        if (trigger instanceof AsyncTriggerConverter) {
            return (AsyncTrigger)((AsyncTriggerConverter)((Object)trigger)).convertToAsync();
        }
        return UserDefinedAsyncTrigger.of(trigger);
    }

    public static class UserDefinedAsyncTrigger<T, W extends Window>
    extends AsyncTrigger<T, W> {
        private final Trigger<T, W> userDefinedTrigger;

        private UserDefinedAsyncTrigger(Trigger<T, W> userDefinedTrigger) {
            this.userDefinedTrigger = userDefinedTrigger;
        }

        @Override
        public StateFuture<TriggerResult> onElement(T element, long timestamp, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return StateFutureUtils.completedFuture((Object)((Object)this.userDefinedTrigger.onElement(element, timestamp, window, AsyncTriggerContextConvertor.of(ctx))));
        }

        @Override
        public StateFuture<TriggerResult> onProcessingTime(long time, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return StateFutureUtils.completedFuture((Object)((Object)this.userDefinedTrigger.onProcessingTime(time, window, AsyncTriggerContextConvertor.of(ctx))));
        }

        @Override
        public StateFuture<TriggerResult> onEventTime(long time, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return StateFutureUtils.completedFuture((Object)((Object)this.userDefinedTrigger.onEventTime(time, window, AsyncTriggerContextConvertor.of(ctx))));
        }

        @Override
        public StateFuture<Void> clear(W window, AsyncTrigger.TriggerContext ctx) throws Exception {
            this.userDefinedTrigger.clear(window, AsyncTriggerContextConvertor.of(ctx));
            return StateFutureUtils.completedVoidFuture();
        }

        @Override
        public boolean isEndOfStreamTrigger() {
            return this.userDefinedTrigger instanceof GlobalWindows.EndOfStreamTrigger;
        }

        public static <T, W extends Window> AsyncTrigger<T, W> of(Trigger<T, W> userDefinedTrigger) {
            return new UserDefinedAsyncTrigger<T, W>(userDefinedTrigger);
        }

        @VisibleForTesting
        public Trigger<T, W> getUserDefinedTrigger() {
            return this.userDefinedTrigger;
        }

        private static class AsyncTriggerContextConvertor
        implements Trigger.TriggerContext {
            private final AsyncTrigger.TriggerContext asyncTriggerContext;

            private AsyncTriggerContextConvertor(AsyncTrigger.TriggerContext asyncTriggerContext) {
                this.asyncTriggerContext = asyncTriggerContext;
            }

            @Override
            public long getCurrentProcessingTime() {
                return this.asyncTriggerContext.getCurrentProcessingTime();
            }

            @Override
            public MetricGroup getMetricGroup() {
                return this.asyncTriggerContext.getMetricGroup();
            }

            @Override
            public long getCurrentWatermark() {
                return this.asyncTriggerContext.getCurrentWatermark();
            }

            @Override
            public void registerProcessingTimeTimer(long time) {
                this.asyncTriggerContext.registerProcessingTimeTimer(time);
            }

            @Override
            public void registerEventTimeTimer(long time) {
                this.asyncTriggerContext.registerEventTimeTimer(time);
            }

            @Override
            public void deleteProcessingTimeTimer(long time) {
                this.asyncTriggerContext.deleteProcessingTimeTimer(time);
            }

            @Override
            public void deleteEventTimeTimer(long time) {
                this.asyncTriggerContext.deleteEventTimeTimer(time);
            }

            @Override
            public <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) {
                throw new UnsupportedOperationException("Trigger is for state V1 APIs, window operator with async state enabled only accept state V2 APIs.");
            }

            public static Trigger.TriggerContext of(AsyncTrigger.TriggerContext asyncTriggerContext) {
                return new AsyncTriggerContextConvertor(asyncTriggerContext);
            }
        }
    }
}

