/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.util.Preconditions;

public class OperatorSubtaskDescriptionText {
    private final String description;

    public OperatorSubtaskDescriptionText(OperatorID operatorId, String operatorClass, int subtaskIndex, int numberOfTasks) {
        Preconditions.checkArgument((numberOfTasks > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((subtaskIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((subtaskIndex < numberOfTasks ? 1 : 0) != 0);
        this.description = operatorClass + "_" + String.valueOf((Object)operatorId) + "_(" + (1 + subtaskIndex) + "/" + numberOfTasks + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorSubtaskDescriptionText that = (OperatorSubtaskDescriptionText)o;
        return this.description.equals(that.description);
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public String toString() {
        return this.description;
    }
}

