/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.LocalSnapshotDirectoryProvider;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotDirectoryProviderImpl
implements LocalSnapshotDirectoryProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotDirectoryProviderImpl.class);
    @Nonnull
    private final File[] allocationBaseDirs;
    @Nonnull
    private final JobID jobID;
    @Nonnull
    private final JobVertexID jobVertexID;
    @Nonnegative
    private final int subtaskIndex;

    public LocalSnapshotDirectoryProviderImpl(File allocationBaseDir, @Nonnull JobID jobID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex) {
        this(new File[]{allocationBaseDir}, jobID, jobVertexID, subtaskIndex);
    }

    public LocalSnapshotDirectoryProviderImpl(@Nonnull File[] allocationBaseDirs, @Nonnull JobID jobID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex) {
        Preconditions.checkArgument((allocationBaseDirs.length > 0 ? 1 : 0) != 0);
        this.allocationBaseDirs = allocationBaseDirs;
        this.jobID = jobID;
        this.jobVertexID = jobVertexID;
        this.subtaskIndex = subtaskIndex;
        for (File allocationBaseDir : allocationBaseDirs) {
            Preconditions.checkNotNull((Object)allocationBaseDir);
            allocationBaseDir.mkdirs();
        }
    }

    @Override
    public File allocationBaseDirectory(long checkpointId) {
        return this.selectAllocationBaseDirectory(((int)checkpointId & Integer.MAX_VALUE) % this.allocationBaseDirs.length);
    }

    @Override
    public File subtaskBaseDirectory(long checkpointId) {
        return new File(this.allocationBaseDirectory(checkpointId), this.subtaskDirString());
    }

    @Override
    public File subtaskSpecificCheckpointDirectory(long checkpointId) {
        return new File(this.subtaskBaseDirectory(checkpointId), this.checkpointDirString(checkpointId));
    }

    @Override
    public File selectAllocationBaseDirectory(int idx) {
        return this.allocationBaseDirs[idx];
    }

    @Override
    public File selectSubtaskBaseDirectory(int idx) {
        return new File(this.selectAllocationBaseDirectory(idx), this.subtaskDirString());
    }

    @Override
    public int allocationBaseDirsCount() {
        return this.allocationBaseDirs.length;
    }

    public String toString() {
        return "LocalRecoveryDirectoryProvider{rootDirectories=" + Arrays.toString(this.allocationBaseDirs) + ", jobID=" + String.valueOf(this.jobID) + ", jobVertexID=" + String.valueOf(this.jobVertexID) + ", subtaskIndex=" + this.subtaskIndex + "}";
    }

    @VisibleForTesting
    String subtaskDirString() {
        return Paths.get("jid_" + String.valueOf(this.jobID), "vtx_" + String.valueOf(this.jobVertexID) + "_sti_" + this.subtaskIndex).toString();
    }

    @VisibleForTesting
    String checkpointDirString(long checkpointId) {
        return "chk_" + checkpointId;
    }
}

