/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.AbstractIncrementalStateHandle;
import org.apache.flink.runtime.state.CheckpointBoundKeyedStateHandle;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;

public class IncrementalLocalKeyedStateHandle
extends AbstractIncrementalStateHandle {
    private static final long serialVersionUID = 1L;
    private final DirectoryStateHandle directoryStateHandle;

    public IncrementalLocalKeyedStateHandle(@Nonnull UUID backendIdentifier, @Nonnegative long checkpointId, @Nonnull DirectoryStateHandle directoryStateHandle, @Nonnull KeyGroupRange keyGroupRange, @Nonnull StreamStateHandle metaDataState, @Nonnull List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState) {
        super(backendIdentifier, keyGroupRange, checkpointId, new ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath>(sharedState), metaDataState, StateHandleID.randomStateHandleId());
        this.directoryStateHandle = directoryStateHandle;
    }

    @Override
    public CheckpointBoundKeyedStateHandle rebound(long checkpointId) {
        return new IncrementalLocalKeyedStateHandle(this.backendIdentifier, checkpointId, this.getDirectoryStateHandle(), this.getKeyGroupRange(), this.getMetaDataStateHandle(), this.getSharedStateHandles());
    }

    @Override
    public void discardState() throws Exception {
        Exception collectedEx = null;
        try {
            this.directoryStateHandle.discardState();
        }
        catch (Exception e) {
            collectedEx = e;
        }
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            collectedEx = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)collectedEx);
        }
        if (collectedEx != null) {
            throw collectedEx;
        }
    }

    @Override
    public long getStateSize() {
        return this.directoryStateHandle.getStateSize() + this.metaStateHandle.getStateSize();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.metaStateHandle.collectSizeStats(collector);
        this.directoryStateHandle.collectSizeStats(collector);
    }

    @Override
    public String toString() {
        return "IncrementalLocalKeyedStateHandle{directoryStateHandle=" + String.valueOf(this.directoryStateHandle) + "} " + super.toString();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
    }

    @Override
    public long getCheckpointedSize() {
        return this.directoryStateHandle.getStateSize();
    }

    @Nonnull
    public DirectoryStateHandle getDirectoryStateHandle() {
        return this.directoryStateHandle;
    }
}

