/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.loading.DefaultLoadingWeight;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.runtime.scheduler.loading.WeightLoadable;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class ExecutionSlotSharingGroup
implements WeightLoadable {
    private final Set<ExecutionVertexID> executionVertexIds;
    @Nonnull
    private final SlotSharingGroup slotSharingGroup;

    public ExecutionSlotSharingGroup(@Nonnull SlotSharingGroup slotSharingGroup) {
        this.slotSharingGroup = (SlotSharingGroup)Preconditions.checkNotNull((Object)slotSharingGroup);
        this.executionVertexIds = new HashSet<ExecutionVertexID>();
    }

    public void addVertex(ExecutionVertexID executionVertexId) {
        this.executionVertexIds.add(executionVertexId);
    }

    @Nonnull
    public SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    @Nonnull
    ResourceProfile getResourceProfile() {
        return this.slotSharingGroup.getResourceProfile();
    }

    public Set<ExecutionVertexID> getExecutionVertexIds() {
        return Collections.unmodifiableSet(this.executionVertexIds);
    }

    public String toString() {
        return "ExecutionSlotSharingGroup{executionVertexIds=" + String.valueOf(this.executionVertexIds) + ", slotSharingGroup=" + String.valueOf(this.slotSharingGroup) + ", loadingWeight=" + String.valueOf(this.getLoading()) + "}";
    }

    @Override
    @Nonnull
    public LoadingWeight getLoading() {
        return new DefaultLoadingWeight(this.executionVertexIds.size());
    }
}

