/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

public final class OpaqueMemoryResource<T>
implements AutoCloseable {
    private final T resourceHandle;
    private final long size;
    private final ThrowingRunnable<Exception> disposer;
    private final AtomicBoolean closed = new AtomicBoolean();

    public OpaqueMemoryResource(T resourceHandle, long size, ThrowingRunnable<Exception> disposer) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be >= 0");
        this.resourceHandle = Preconditions.checkNotNull(resourceHandle, (String)"resourceHandle");
        this.disposer = (ThrowingRunnable)Preconditions.checkNotNull(disposer, (String)"disposer");
        this.size = size;
    }

    public T getResourceHandle() {
        return this.resourceHandle;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.disposer.run();
        }
    }

    public String toString() {
        return "OpaqueMemoryResource (" + this.size + " bytes) @ " + String.valueOf(this.resourceHandle) + (this.closed.get() ? " (disposed)" : "");
    }
}

