/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationContext;
import org.apache.flink.runtime.asyncprocessing.declare.DeclaredVariable;
import org.apache.flink.runtime.asyncprocessing.functions.DeclaringAsyncKeyedProcessFunction;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateUdfStreamOperator;
import org.apache.flink.runtime.asyncprocessing.operators.TimestampedCollectorWithDeclaredVariable;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
public class AsyncKeyedProcessOperator<K, IN, OUT>
extends AbstractAsyncStateUdfStreamOperator<OUT, KeyedProcessFunction<K, IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
Triggerable<K, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private transient DeclaredVariable<Long> sharedTimestamp;
    private transient TimestampedCollectorWithDeclaredVariable<OUT> collector;
    private transient ContextImpl context;
    private transient OnTimerContextImpl onTimerContext;
    private transient ThrowingConsumer<IN, Exception> processor;
    private transient ThrowingConsumer<Long, Exception> timerProcessor;

    public AsyncKeyedProcessOperator(KeyedProcessFunction<K, IN, OUT> function) {
        super(function);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.sharedTimestamp = this.declarationContext.declareVariable(LongSerializer.INSTANCE, "_AsyncKeyedProcessOperator$sharedTimestamp", null);
        this.collector = new TimestampedCollectorWithDeclaredVariable(this.output, this.sharedTimestamp);
        InternalTimerService<VoidNamespace> internalTimerService = this.getInternalTimerService("user-timers", VoidNamespaceSerializer.INSTANCE, this);
        SimpleTimerService timerService = new SimpleTimerService(internalTimerService);
        this.context = new ContextImpl((KeyedProcessFunction)this.userFunction, timerService, this.sharedTimestamp);
        this.onTimerContext = new OnTimerContextImpl((KeyedProcessFunction)this.userFunction, timerService, this.declarationContext);
        if (this.userFunction instanceof DeclaringAsyncKeyedProcessFunction) {
            DeclaringAsyncKeyedProcessFunction declaringFunction = (DeclaringAsyncKeyedProcessFunction)this.userFunction;
            declaringFunction.declareVariables(this.declarationContext);
            this.processor = declaringFunction.declareProcess(this.declarationContext, this.context, this.collector);
            this.timerProcessor = declaringFunction.declareOnTimer(this.declarationContext, this.onTimerContext, this.collector);
        } else {
            this.processor = in -> ((KeyedProcessFunction)this.userFunction).processElement(in, this.context, this.collector);
            this.timerProcessor = in -> ((KeyedProcessFunction)this.userFunction).onTimer((long)in, this.onTimerContext, this.collector);
        }
    }

    @Override
    public void onEventTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        this.invokeUserFunction(TimeDomain.EVENT_TIME, timer);
    }

    @Override
    public void onProcessingTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.eraseTimestamp();
        this.invokeUserFunction(TimeDomain.PROCESSING_TIME, timer);
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.collector.setTimestamp(element);
        this.processor.accept(element.getValue());
    }

    private void invokeUserFunction(TimeDomain timeDomain, InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.onTimerContext.setTime(timer.getTimestamp(), timeDomain);
        this.timerProcessor.accept((Object)timer.getTimestamp());
    }

    private class OnTimerContextImpl
    extends KeyedProcessFunction.OnTimerContext {
        private final TimerService timerService;
        private final DeclaredVariable<String> timeDomain;
        private final DeclaredVariable<Long> timestamp;

        OnTimerContextImpl(KeyedProcessFunction<K, IN, OUT> function, TimerService timerService, DeclarationContext declarationContext) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
            this.timeDomain = declarationContext.declareVariable(StringSerializer.INSTANCE, "_OnTimerContextImpl$timeDomain", null);
            this.timestamp = declarationContext.declareVariable(LongSerializer.INSTANCE, "_OnTimerContextImpl$timestamp", null);
        }

        public void setTime(long time, TimeDomain one) {
            this.timestamp.set(time);
            this.timeDomain.set(one.name());
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.timestamp.get() != null ? 1 : 0) != 0);
            return (Long)this.timestamp.get();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            AsyncKeyedProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.timestamp()));
        }

        @Override
        public TimeDomain timeDomain() {
            Preconditions.checkState((this.timeDomain.get() != null ? 1 : 0) != 0);
            return TimeDomain.valueOf((String)this.timeDomain.get());
        }

        @Override
        public K getCurrentKey() {
            return AsyncKeyedProcessOperator.this.getCurrentKey();
        }
    }

    private class ContextImpl
    extends KeyedProcessFunction.Context {
        private final TimerService timerService;
        private final DeclaredVariable<Long> timestamp;

        ContextImpl(KeyedProcessFunction<K, IN, OUT> function, TimerService timerService, DeclaredVariable<Long> timestamp) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
            this.timestamp = timestamp;
        }

        @Override
        public Long timestamp() {
            return (Long)this.timestamp.get();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            AsyncKeyedProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, (Long)this.timestamp.get()));
        }

        @Override
        public K getCurrentKey() {
            return AsyncKeyedProcessOperator.this.getCurrentKey();
        }
    }
}

