/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.lib;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.RichSourceReaderContext;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class InputFormatSource<OUT>
implements Source<OUT, SourceSplit, Void> {
    private static final long serialVersionUID = 1L;
    private final Boundedness boundedness;
    private final InputFormat<OUT, InputSplit> format;

    public InputFormatSource(Boundedness boundedness, InputFormat<OUT, ?> format) {
        this.boundedness = boundedness;
        this.format = format;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SplitEnumerator<SourceSplit, Void> createEnumerator(SplitEnumeratorContext<SourceSplit> context) throws Exception {
        return new InputFormatSplitEnumerator<OUT>(this.format, context);
    }

    public SplitEnumerator<SourceSplit, Void> restoreEnumerator(SplitEnumeratorContext<SourceSplit> context, Void checkpoint) throws Exception {
        return new InputFormatSplitEnumerator<OUT>(this.format, context);
    }

    public SimpleVersionedSerializer<SourceSplit> getSplitSerializer() {
        return new SimpleVersionedSerializer<SourceSplit>(){

            public int getVersion() {
                return 0;
            }

            public byte[] serialize(SourceSplit split) throws IOException {
                return InstantiationUtil.serializeObject((Object)split);
            }

            public SourceSplit deserialize(int version, byte[] serialized) throws IOException {
                try {
                    return (SourceSplit)InstantiationUtil.deserializeObject((byte[])serialized, (ClassLoader)Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Failed to deserialize SourceSplit.", e);
                }
            }
        };
    }

    public SimpleVersionedSerializer<Void> getEnumeratorCheckpointSerializer() {
        return new SimpleVersionedSerializer<Void>(){

            public int getVersion() {
                return 0;
            }

            public byte[] serialize(Void obj) {
                return new byte[0];
            }

            public Void deserialize(int version, byte[] serialized) {
                return null;
            }
        };
    }

    public SourceReader<OUT, SourceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        RuntimeContext runtimeContext = null;
        if (readerContext instanceof RichSourceReaderContext) {
            runtimeContext = ((RichSourceReaderContext)readerContext).getRuntimeContext();
        }
        return new InputFormatSourceReader<OUT>(readerContext, this.format, runtimeContext);
    }

    private static class InputFormatSourceReader<OUT>
    implements SourceReader<OUT, SourceSplit> {
        private final SourceReaderContext readerContext;
        private final InputFormat<OUT, InputSplit> format;
        @Nullable
        private final RuntimeContext runtimeContext;
        @Nullable
        private Counter completedSplitsCounter;
        private Queue<SourceSplit> remainingSplits;
        private boolean noMoreSplits;
        private boolean isFormatOpen;
        private OUT lastElement;

        public InputFormatSourceReader(SourceReaderContext readerContext, InputFormat<OUT, InputSplit> format, @Nullable RuntimeContext runtimeContext) {
            this.format = format;
            this.runtimeContext = runtimeContext;
            this.readerContext = readerContext;
        }

        public void start() {
            this.remainingSplits = new LinkedList<SourceSplit>();
            if (this.runtimeContext != null) {
                this.completedSplitsCounter = this.runtimeContext.getMetricGroup().counter("numSplitsProcessed");
            }
            this.noMoreSplits = false;
            this.isFormatOpen = false;
            this.lastElement = null;
            if (this.format instanceof RichInputFormat) {
                ((RichInputFormat)this.format).setRuntimeContext(this.runtimeContext);
            }
            this.format.configure(this.readerContext.getConfiguration());
            if (this.format instanceof RichInputFormat) {
                try {
                    ((RichInputFormat)this.format).openInputFormat();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.readerContext.sendSplitRequest();
        }

        public InputStatus pollNext(ReaderOutput<OUT> output) throws Exception {
            InputSplitWrapperSourceSplit split;
            if (!this.isFormatOpen && (split = (InputSplitWrapperSourceSplit)this.remainingSplits.poll()) != null) {
                this.format.open(split.getInputSplit());
                this.isFormatOpen = true;
                if (this.remainingSplits.isEmpty() && !this.noMoreSplits) {
                    this.readerContext.sendSplitRequest();
                }
            }
            if (this.isFormatOpen && !this.format.reachedEnd()) {
                this.lastElement = this.format.nextRecord(this.lastElement);
                output.collect(this.lastElement);
                return InputStatus.MORE_AVAILABLE;
            }
            this.format.close();
            this.isFormatOpen = false;
            if (this.completedSplitsCounter != null) {
                this.completedSplitsCounter.inc();
            }
            if (this.remainingSplits.isEmpty()) {
                if (this.noMoreSplits) {
                    return InputStatus.END_OF_INPUT;
                }
                return InputStatus.NOTHING_AVAILABLE;
            }
            return InputStatus.MORE_AVAILABLE;
        }

        public List<SourceSplit> snapshotState(long checkpointId) {
            return List.of();
        }

        public CompletableFuture<Void> isAvailable() {
            return CompletableFuture.completedFuture(null);
        }

        public void addSplits(List<SourceSplit> splits) {
            this.remainingSplits.addAll(splits);
        }

        public void notifyNoMoreSplits() {
            this.noMoreSplits = true;
        }

        public void close() throws Exception {
            if (this.isFormatOpen) {
                this.format.close();
                this.isFormatOpen = false;
            }
            if (this.format instanceof RichInputFormat) {
                ((RichInputFormat)this.format).closeInputFormat();
            }
        }
    }

    private static class InputFormatSplitEnumerator<OUT>
    implements SplitEnumerator<SourceSplit, Void> {
        private final InputFormat<OUT, InputSplit> format;
        private final SplitEnumeratorContext<SourceSplit> context;
        private Queue<SourceSplit> remainingSplits;

        public InputFormatSplitEnumerator(InputFormat<OUT, InputSplit> format, SplitEnumeratorContext<SourceSplit> context) {
            this.format = format;
            this.context = context;
        }

        public void start() {
            try {
                this.remainingSplits = Arrays.stream(this.format.createInputSplits(this.context.currentParallelism())).map(InputSplitWrapperSourceSplit::new).collect(Collectors.toCollection(LinkedList::new));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
            SourceSplit nextSplit = this.remainingSplits.poll();
            if (nextSplit != null) {
                this.context.assignSplit(nextSplit, subtaskId);
            } else {
                this.context.signalNoMoreSplits(subtaskId);
            }
        }

        public void addSplitsBack(List<SourceSplit> splits, int subtaskId) {
            this.remainingSplits.addAll(splits);
        }

        public void addReader(int subtaskId) {
        }

        public Void snapshotState(long checkpointId) {
            return null;
        }

        public void close() {
        }
    }

    private static class InputSplitWrapperSourceSplit
    implements SourceSplit,
    Serializable {
        private final InputSplit inputSplit;
        private final String id;

        public InputSplitWrapperSourceSplit(InputSplit inputSplit) {
            this.inputSplit = inputSplit;
            this.id = String.valueOf(inputSplit.getSplitNumber());
        }

        public InputSplit getInputSplit() {
            return this.inputSplit;
        }

        public String splitId() {
            return this.id;
        }
    }
}

