/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.reader.MutableRecordReader;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.streaming.runtime.io.benchmark.ReceiverThread;
import org.apache.flink.types.LongValue;

public class SerializingLongReceiver
extends ReceiverThread {
    private final MutableRecordReader<LongValue> reader;

    public SerializingLongReceiver(InputGate inputGate, int expectedRepetitionsOfExpectedRecord) {
        super(expectedRepetitionsOfExpectedRecord);
        this.reader = new MutableRecordReader(inputGate, new String[]{EnvironmentInformation.getTemporaryFileDirectory()});
    }

    @Override
    protected void readRecords(long lastExpectedRecord) throws Exception {
        LOG.debug("readRecords(lastExpectedRecord = {})", (Object)lastExpectedRecord);
        LongValue value = new LongValue();
        while (this.running && this.reader.next((IOReadableWritable)value)) {
            long ts = value.getValue();
            if (ts != lastExpectedRecord) continue;
            ++this.expectedRecordCounter;
            if (this.expectedRecordCounter != this.expectedRepetitionsOfExpectedRecord) continue;
            break;
        }
    }
}

