/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.util.List;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;

public class ListSourceContext<T>
implements SourceFunction.SourceContext<T> {
    private final Object lock = new Object();
    private final List<T> target;
    private final long delay;

    public ListSourceContext(List<T> target) {
        this(target, 0L);
    }

    public ListSourceContext(List<T> target, long delay) {
        this.target = target;
        this.delay = delay;
    }

    public void collect(T element) {
        this.target.add(element);
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void collectWithTimestamp(T element, long timestamp) {
        this.target.add(element);
    }

    public void emitWatermark(Watermark mark) {
        throw new UnsupportedOperationException();
    }

    public void markAsTemporarilyIdle() {
        throw new UnsupportedOperationException();
    }

    public Object getCheckpointLock() {
        return this.lock;
    }

    public void close() {
    }
}

