/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessageSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.runtime.operators.sink.IntegerSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CommittableMessageSerializerTest {
    private static final CommittableMessageSerializer<Integer> SERIALIZER = new CommittableMessageSerializer((SimpleVersionedSerializer)new IntegerSerializer());

    CommittableMessageSerializerTest() {
    }

    @Test
    void testCommittableWithLinageSerDe() throws IOException {
        CommittableWithLineage committableWithLineage = new CommittableWithLineage((Object)1, 2L, 3);
        CommittableMessage message = SERIALIZER.deserialize(1, SERIALIZER.serialize((CommittableMessage)committableWithLineage));
        Assertions.assertThat((Object)message).isInstanceOf(CommittableWithLineage.class);
        CommittableWithLineage copy = (CommittableWithLineage)message;
        Assertions.assertThat((Integer)((Integer)copy.getCommittable())).isEqualTo(1);
        Assertions.assertThat((long)copy.getCheckpointIdOrEOI()).isEqualTo(2L);
        Assertions.assertThat((int)copy.getSubtaskId()).isEqualTo(3);
    }

    @Test
    void testCommittableSummarySerDe() throws IOException {
        CommittableSummary committableSummary = new CommittableSummary(1, 2, 3L, 4, 5);
        CommittableMessage message = SERIALIZER.deserialize(1, SERIALIZER.serialize((CommittableMessage)committableSummary));
        Assertions.assertThat((Object)message).isInstanceOf(CommittableSummary.class);
        CommittableSummary copy = (CommittableSummary)message;
        Assertions.assertThat((int)copy.getSubtaskId()).isEqualTo(1);
        Assertions.assertThat((int)copy.getNumberOfSubtasks()).isEqualTo(2);
        Assertions.assertThat((long)copy.getCheckpointIdOrEOI()).isEqualTo(3L);
        Assertions.assertThat((int)copy.getNumberOfCommittables()).isEqualTo(4);
    }
}

