/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateLatencyTrackOptions;
import org.apache.flink.configuration.StateSizeTrackOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricsTrackingStateConfigTest {
    MetricsTrackingStateConfigTest() {
    }

    @Test
    void testDefaultDisabledLatencyTrackingStateConfig() {
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isFalse();
    }

    @Test
    void testDefaultEnabledLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = ((LatencyTrackingStateConfig.Builder)((LatencyTrackingStateConfig.Builder)LatencyTrackingStateConfig.newBuilder().setEnabled(true)).setMetricGroup((MetricGroup)metricsGroup)).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(((Integer)StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue()).intValue());
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo((long)((Integer)StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue()).intValue());
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isStateNameAsVariable()).isEqualTo(StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE.defaultValue());
    }

    @Test
    void testSetLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = ((LatencyTrackingStateConfig.Builder)((LatencyTrackingStateConfig.Builder)((LatencyTrackingStateConfig.Builder)((LatencyTrackingStateConfig.Builder)LatencyTrackingStateConfig.newBuilder().setMetricGroup((MetricGroup)metricsGroup)).setEnabled(true)).setSampleInterval(10)).setHistorySize(500)).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }

    @Test
    void testConfigureFromReadableConfig() {
        LatencyTrackingStateConfig.Builder builder = LatencyTrackingStateConfig.newBuilder();
        Configuration configuration = new Configuration();
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_ENABLED, (Object)true);
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL, (Object)10);
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE, (Object)500);
        LatencyTrackingStateConfig latencyTrackingStateConfig = ((LatencyTrackingStateConfig.Builder)builder.configure((ReadableConfig)configuration).setMetricGroup((MetricGroup)new UnregisteredMetricsGroup())).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }

    @Test
    void testDefaultDisabledSizeTrackingStateConfig() {
        SizeTrackingStateConfig sizeTrackingStateConfig = SizeTrackingStateConfig.newBuilder().build();
        Assertions.assertThat((boolean)sizeTrackingStateConfig.isEnabled()).isFalse();
    }

    @Test
    void testDefaultEnabledSizeTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        SizeTrackingStateConfig sizeTrackingStateConfig = ((SizeTrackingStateConfig.Builder)((SizeTrackingStateConfig.Builder)SizeTrackingStateConfig.newBuilder().setEnabled(true)).setMetricGroup((MetricGroup)metricsGroup)).build();
        Assertions.assertThat((boolean)sizeTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)sizeTrackingStateConfig.getSampleInterval()).isEqualTo(((Integer)StateSizeTrackOptions.SIZE_TRACK_SAMPLE_INTERVAL.defaultValue()).intValue());
        Assertions.assertThat((int)sizeTrackingStateConfig.getHistorySize()).isEqualTo((long)((Integer)StateSizeTrackOptions.SIZE_TRACK_HISTORY_SIZE.defaultValue()).intValue());
        Assertions.assertThat((boolean)sizeTrackingStateConfig.isStateNameAsVariable()).isEqualTo(StateSizeTrackOptions.SIZE_TRACK_STATE_NAME_AS_VARIABLE.defaultValue());
    }

    @Test
    void testSetSizeTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        SizeTrackingStateConfig sizeTrackingStateConfig = ((SizeTrackingStateConfig.Builder)((SizeTrackingStateConfig.Builder)((SizeTrackingStateConfig.Builder)((SizeTrackingStateConfig.Builder)SizeTrackingStateConfig.newBuilder().setMetricGroup((MetricGroup)metricsGroup)).setEnabled(true)).setSampleInterval(10)).setHistorySize(500)).build();
        Assertions.assertThat((boolean)sizeTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)sizeTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)sizeTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }

    @Test
    void testConfigureFromReadableConfig1() {
        SizeTrackingStateConfig.Builder builder = SizeTrackingStateConfig.newBuilder();
        Configuration configuration = new Configuration();
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_ENABLED, (Object)true);
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_SAMPLE_INTERVAL, (Object)10);
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_HISTORY_SIZE, (Object)500);
        SizeTrackingStateConfig sizeTrackingStateConfig = ((SizeTrackingStateConfig.Builder)builder.configure((ReadableConfig)configuration).setMetricGroup((MetricGroup)new UnregisteredMetricsGroup())).build();
        Assertions.assertThat((boolean)sizeTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)sizeTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)sizeTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }
}

