/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.MetricsTrackingReducingState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricsTrackingReducingStateTest
extends MetricsTrackingStateTestBase<Integer> {
    MetricsTrackingReducingStateTest() {
    }

    ReducingStateDescriptor<Long> getStateDescriptor() {
        return new ReducingStateDescriptor("reducing", Long::sum, Long.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingReducingState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingReducingState latencyTrackingState = (MetricsTrackingReducingState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingReducingState.ReducingStateMetrics latencyTrackingStateMetric = (MetricsTrackingReducingState.ReducingStateMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getAddCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getMergeNamespaceCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.add((Object)random.nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getAddCount()).isEqualTo(expectedResult);
                latencyTrackingState.get();
                Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
                latencyTrackingState.mergeNamespaces((Object)VoidNamespace.INSTANCE, Collections.emptyList());
                Assertions.assertThat((int)latencyTrackingStateMetric.getMergeNamespaceCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeTrackingReducingState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingReducingState sizeTrackingState = (MetricsTrackingReducingState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            sizeTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingReducingState.ReducingStateMetrics sizeTrackingStateMetric = (MetricsTrackingReducingState.ReducingStateMetrics)sizeTrackingState.getSizeTrackingStateMetric();
            Assertions.assertThat((int)sizeTrackingStateMetric.getAddCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getMergeNamespaceCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                sizeTrackingState.add((Object)random.nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getAddCount()).isEqualTo(expectedResult);
                sizeTrackingState.get();
                Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

