/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompositeKeySerializationUtilsTest {
    CompositeKeySerializationUtilsTest() {
    }

    @Test
    void testIsAmbiguousKeyPossible() {
        Assertions.assertThat((boolean)CompositeKeySerializationUtils.isAmbiguousKeyPossible((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE)).isFalse();
        Assertions.assertThat((boolean)CompositeKeySerializationUtils.isAmbiguousKeyPossible((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE)).isTrue();
    }

    @Test
    void testKeyGroupSerializationAndDeserialization() throws Exception {
        ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos(8);
        DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
        for (int keyGroupPrefixBytes = 1; keyGroupPrefixBytes <= 2; ++keyGroupPrefixBytes) {
            for (int orgKeyGroup = 0; orgKeyGroup < 128; ++orgKeyGroup) {
                outputStream.reset();
                CompositeKeySerializationUtils.writeKeyGroup((int)orgKeyGroup, (int)keyGroupPrefixBytes, (DataOutputView)outputView);
                int deserializedKeyGroup = CompositeKeySerializationUtils.readKeyGroup((int)keyGroupPrefixBytes, (DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStreamWithPos(outputStream.toByteArray())));
                Assertions.assertThat((int)deserializedKeyGroup).isEqualTo(orgKeyGroup);
            }
        }
    }

    @Test
    void testKeySerializationAndDeserialization() throws Exception {
        DataOutputSerializer outputView = new DataOutputSerializer(8);
        DataInputDeserializer inputView = new DataInputDeserializer();
        for (int orgKey = 0; orgKey < 100; ++orgKey) {
            outputView.clear();
            CompositeKeySerializationUtils.writeKey((Object)orgKey, (TypeSerializer)IntSerializer.INSTANCE, (DataOutputSerializer)outputView, (boolean)false);
            inputView.setBuffer(outputView.getCopyOfBuffer());
            int deserializedKey = (Integer)CompositeKeySerializationUtils.readKey((TypeSerializer)IntSerializer.INSTANCE, (DataInputDeserializer)inputView, (boolean)false);
            Assertions.assertThat((int)deserializedKey).isEqualTo(orgKey);
            CompositeKeySerializationUtils.writeKey((Object)orgKey, (TypeSerializer)IntSerializer.INSTANCE, (DataOutputSerializer)outputView, (boolean)true);
            inputView.setBuffer(outputView.getCopyOfBuffer());
            deserializedKey = (Integer)CompositeKeySerializationUtils.readKey((TypeSerializer)IntSerializer.INSTANCE, (DataInputDeserializer)inputView, (boolean)true);
            Assertions.assertThat((int)deserializedKey).isEqualTo(orgKey);
        }
    }

    @Test
    void testNamespaceSerializationAndDeserialization() throws Exception {
        DataOutputSerializer outputView = new DataOutputSerializer(8);
        DataInputDeserializer inputView = new DataInputDeserializer();
        for (int orgNamespace = 0; orgNamespace < 100; ++orgNamespace) {
            outputView.clear();
            CompositeKeySerializationUtils.writeNameSpace((Object)orgNamespace, (TypeSerializer)IntSerializer.INSTANCE, (DataOutputSerializer)outputView, (boolean)false);
            inputView.setBuffer(outputView.getCopyOfBuffer());
            int deserializedNamepsace = (Integer)CompositeKeySerializationUtils.readNamespace((TypeSerializer)IntSerializer.INSTANCE, (DataInputDeserializer)inputView, (boolean)false);
            Assertions.assertThat((int)deserializedNamepsace).isEqualTo(orgNamespace);
            CompositeKeySerializationUtils.writeNameSpace((Object)orgNamespace, (TypeSerializer)IntSerializer.INSTANCE, (DataOutputSerializer)outputView, (boolean)true);
            inputView.setBuffer(outputView.getCopyOfBuffer());
            deserializedNamepsace = (Integer)CompositeKeySerializationUtils.readNamespace((TypeSerializer)IntSerializer.INSTANCE, (DataInputDeserializer)inputView, (boolean)true);
            Assertions.assertThat((int)deserializedNamepsace).isEqualTo(orgNamespace);
        }
    }
}

